<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addToContainer StructType
 * @subpackage Structs
 */
class AddToContainer extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The parentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $parentId;
    /**
     * The index
     * @var int
     */
    public $index;
    /**
     * The updateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $updateId;
    /**
     * Constructor method for addToContainer
     * @uses AddToContainer::setId()
     * @uses AddToContainer::setParentId()
     * @uses AddToContainer::setIndex()
     * @uses AddToContainer::setUpdateId()
     * @param string $id
     * @param string $parentId
     * @param int $index
     * @param string $updateId
     */
    public function __construct($id = null, $parentId = null, $index = null, $updateId = null)
    {
        $this
            ->setId($id)
            ->setParentId($parentId)
            ->setIndex($index)
            ->setUpdateId($updateId);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AddToContainer
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get parentId value
     * @return string|null
     */
    public function getParentId()
    {
        return $this->parentId;
    }
    /**
     * Set parentId value
     * @param string $parentId
     * @return \StructType\AddToContainer
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($parentId) && mb_strlen($parentId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($parentId)), __LINE__);
        }
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\AddToContainer
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get updateId value
     * @return string|null
     */
    public function getUpdateId()
    {
        return $this->updateId;
    }
    /**
     * Set updateId value
     * @param string $updateId
     * @return \StructType\AddToContainer
     */
    public function setUpdateId($updateId = null)
    {
        // validation for constraint: string
        if (!is_null($updateId) && !is_string($updateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateId, true), gettype($updateId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($updateId) && mb_strlen($updateId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($updateId)), __LINE__);
        }
        $this->updateId = $updateId;
        return $this;
    }
}
