<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractMedia StructType
 * @subpackage Structs
 */
abstract class AbstractMedia extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The itemType
     * Meta information extracted from the WSDL
     * - ref: tns:itemType
     * @var string
     */
    public $itemType;
    /**
     * The semanticType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:semanticType
     * @var string
     */
    public $semanticType;
    /**
     * The displayType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayType;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The summary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $summary;
    /**
     * The isFavorite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFavorite;
    /**
     * The tags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TagsData
     */
    public $tags;
    /**
     * The isExplicit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isExplicit;
    /**
     * The isEphemeral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEphemeral;
    /**
     * The positionInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionInformation
     */
    public $positionInformation;
    /**
     * The releaseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $releaseDate;
    /**
     * Constructor method for AbstractMedia
     * @uses AbstractMedia::setId()
     * @uses AbstractMedia::setItemType()
     * @uses AbstractMedia::setSemanticType()
     * @uses AbstractMedia::setDisplayType()
     * @uses AbstractMedia::setTitle()
     * @uses AbstractMedia::setSummary()
     * @uses AbstractMedia::setIsFavorite()
     * @uses AbstractMedia::setTags()
     * @uses AbstractMedia::setIsExplicit()
     * @uses AbstractMedia::setIsEphemeral()
     * @uses AbstractMedia::setPositionInformation()
     * @uses AbstractMedia::setReleaseDate()
     * @param string $id
     * @param string $itemType
     * @param string $semanticType
     * @param string $displayType
     * @param string $title
     * @param string $summary
     * @param bool $isFavorite
     * @param \StructType\TagsData $tags
     * @param bool $isExplicit
     * @param bool $isEphemeral
     * @param \StructType\PositionInformation $positionInformation
     * @param string $releaseDate
     */
    public function __construct($id = null, $itemType = null, $semanticType = null, $displayType = null, $title = null, $summary = null, $isFavorite = null, \StructType\TagsData $tags = null, $isExplicit = null, $isEphemeral = null, \StructType\PositionInformation $positionInformation = null, $releaseDate = null)
    {
        $this
            ->setId($id)
            ->setItemType($itemType)
            ->setSemanticType($semanticType)
            ->setDisplayType($displayType)
            ->setTitle($title)
            ->setSummary($summary)
            ->setIsFavorite($isFavorite)
            ->setTags($tags)
            ->setIsExplicit($isExplicit)
            ->setIsEphemeral($isEphemeral)
            ->setPositionInformation($positionInformation)
            ->setReleaseDate($releaseDate);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AbstractMedia
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get itemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\AbstractMedia
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get semanticType value
     * @return string|null
     */
    public function getSemanticType()
    {
        return $this->semanticType;
    }
    /**
     * Set semanticType value
     * @uses \EnumType\SemanticType::valueIsValid()
     * @uses \EnumType\SemanticType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $semanticType
     * @return \StructType\AbstractMedia
     */
    public function setSemanticType($semanticType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SemanticType::valueIsValid($semanticType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SemanticType', is_array($semanticType) ? implode(', ', $semanticType) : var_export($semanticType, true), implode(', ', \EnumType\SemanticType::getValidValues())), __LINE__);
        }
        $this->semanticType = $semanticType;
        return $this;
    }
    /**
     * Get displayType value
     * @return string|null
     */
    public function getDisplayType()
    {
        return $this->displayType;
    }
    /**
     * Set displayType value
     * @param string $displayType
     * @return \StructType\AbstractMedia
     */
    public function setDisplayType($displayType = null)
    {
        // validation for constraint: string
        if (!is_null($displayType) && !is_string($displayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayType, true), gettype($displayType)), __LINE__);
        }
        $this->displayType = $displayType;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\AbstractMedia
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get summary value
     * @return string|null
     */
    public function getSummary()
    {
        return $this->summary;
    }
    /**
     * Set summary value
     * @param string $summary
     * @return \StructType\AbstractMedia
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        $this->summary = $summary;
        return $this;
    }
    /**
     * Get isFavorite value
     * @return bool|null
     */
    public function getIsFavorite()
    {
        return $this->isFavorite;
    }
    /**
     * Set isFavorite value
     * @param bool $isFavorite
     * @return \StructType\AbstractMedia
     */
    public function setIsFavorite($isFavorite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFavorite) && !is_bool($isFavorite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFavorite, true), gettype($isFavorite)), __LINE__);
        }
        $this->isFavorite = $isFavorite;
        return $this;
    }
    /**
     * Get tags value
     * @return \StructType\TagsData|null
     */
    public function getTags()
    {
        return $this->tags;
    }
    /**
     * Set tags value
     * @param \StructType\TagsData $tags
     * @return \StructType\AbstractMedia
     */
    public function setTags(\StructType\TagsData $tags = null)
    {
        $this->tags = $tags;
        return $this;
    }
    /**
     * Get isExplicit value
     * @return bool|null
     */
    public function getIsExplicit()
    {
        return $this->isExplicit;
    }
    /**
     * Set isExplicit value
     * @param bool $isExplicit
     * @return \StructType\AbstractMedia
     */
    public function setIsExplicit($isExplicit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExplicit) && !is_bool($isExplicit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExplicit, true), gettype($isExplicit)), __LINE__);
        }
        $this->isExplicit = $isExplicit;
        return $this;
    }
    /**
     * Get isEphemeral value
     * @return bool|null
     */
    public function getIsEphemeral()
    {
        return $this->isEphemeral;
    }
    /**
     * Set isEphemeral value
     * @param bool $isEphemeral
     * @return \StructType\AbstractMedia
     */
    public function setIsEphemeral($isEphemeral = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEphemeral) && !is_bool($isEphemeral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEphemeral, true), gettype($isEphemeral)), __LINE__);
        }
        $this->isEphemeral = $isEphemeral;
        return $this;
    }
    /**
     * Get positionInformation value
     * @return \StructType\PositionInformation|null
     */
    public function getPositionInformation()
    {
        return $this->positionInformation;
    }
    /**
     * Set positionInformation value
     * @param \StructType\PositionInformation $positionInformation
     * @return \StructType\AbstractMedia
     */
    public function setPositionInformation(\StructType\PositionInformation $positionInformation = null)
    {
        $this->positionInformation = $positionInformation;
        return $this;
    }
    /**
     * Get releaseDate value
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->releaseDate;
    }
    /**
     * Set releaseDate value
     * @param string $releaseDate
     * @return \StructType\AbstractMedia
     */
    public function setReleaseDate($releaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($releaseDate) && !is_string($releaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseDate, true), gettype($releaseDate)), __LINE__);
        }
        $this->releaseDate = $releaseDate;
        return $this;
    }
}
