<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Report ServiceType
 * @subpackage Services
 */
class Report extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Credentials $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\Credentials $credentials, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\StructType\Context $context, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named reportStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportStatus $parameters
     * @return \StructType\ReportStatusResponse|bool
     */
    public function reportStatus(\StructType\ReportStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reportStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named reportPlaySeconds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportPlaySeconds $parameters
     * @return \StructType\ReportPlaySecondsResponse|bool
     */
    public function reportPlaySeconds(\StructType\ReportPlaySeconds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reportPlaySeconds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named reportPlayStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportPlayStatus $parameters
     * @return \StructType\ReportPlayStatusResponse|bool
     */
    public function reportPlayStatus(\StructType\ReportPlayStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reportPlayStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named reportAccountAction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportAccountAction $parameters
     * @return \StructType\ReportAccountActionResponse|bool
     */
    public function reportAccountAction(\StructType\ReportAccountAction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reportAccountAction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReportAccountActionResponse|\StructType\ReportPlaySecondsResponse|\StructType\ReportPlayStatusResponse|\StructType\ReportStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
