<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Credentials $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\Credentials $credentials, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\StructType\Context $context, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getSessionId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionId $parameters
     * @return \StructType\GetSessionIdResponse|bool
     */
    public function getSessionId(\StructType\GetSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMetadata
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMetadata $parameters
     * @return \StructType\GetMetadataResponse|bool
     */
    public function getMetadata(\StructType\GetMetadata $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMetadata($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExtendedMetadata
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExtendedMetadata $parameters
     * @return \StructType\GetExtendedMetadataResponse|bool
     */
    public function getExtendedMetadata(\StructType\GetExtendedMetadata $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getExtendedMetadata($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExtendedMetadataText
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExtendedMetadataText $parameters
     * @return \StructType\GetExtendedMetadataTextResponse|bool
     */
    public function getExtendedMetadataText(\StructType\GetExtendedMetadataText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getExtendedMetadataText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserInfo $parameters
     * @return \StructType\GetUserInfoResponse|bool
     */
    public function getUserInfo(\StructType\GetUserInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaMetadata
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaMetadata $parameters
     * @return \StructType\GetMediaMetadataResponse|bool
     */
    public function getMediaMetadata(\StructType\GetMediaMetadata $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaMetadata($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaURI
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaURI $parameters
     * @return \StructType\GetMediaURIResponse|bool
     */
    public function getMediaURI(\StructType\GetMediaURI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaURI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getScrollIndices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetScrollIndices $parameters
     * @return \StructType\GetScrollIndicesResponse|bool
     */
    public function getScrollIndices(\StructType\GetScrollIndices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getScrollIndices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLastUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastUpdate $parameters
     * @return \StructType\GetLastUpdateResponse|bool
     */
    public function getLastUpdate(\StructType\GetLastUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLastUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppLink
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAppLink $parameters
     * @return \StructType\GetAppLinkResponse|bool
     */
    public function getAppLink(\StructType\GetAppLink $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppLink($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceLinkCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceLinkCode $parameters
     * @return \StructType\GetDeviceLinkCodeResponse|bool
     */
    public function getDeviceLinkCode(\StructType\GetDeviceLinkCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceLinkCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceAuthToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceAuthToken $parameters
     * @return \StructType\GetDeviceAuthTokenResponse|bool
     */
    public function getDeviceAuthToken(\StructType\GetDeviceAuthToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceAuthToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContentKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContentKey $parameters
     * @return \StructType\GetContentKeyResponse|bool
     */
    public function getContentKey(\StructType\GetContentKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getContentKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAppLinkResponse|\StructType\GetContentKeyResponse|\StructType\GetDeviceAuthTokenResponse|\StructType\GetDeviceLinkCodeResponse|\StructType\GetExtendedMetadataResponse|\StructType\GetExtendedMetadataTextResponse|\StructType\GetLastUpdateResponse|\StructType\GetMediaMetadataResponse|\StructType\GetMediaURIResponse|\StructType\GetMetadataResponse|\StructType\GetScrollIndicesResponse|\StructType\GetSessionIdResponse|\StructType\GetUserInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
