<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://developer-assets.ws.sonos.com/files/Sonoswsdl-1.19.4-20190411.142401-3.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://developer-assets.ws.sonos.com/files/Sonoswsdl-1.19.4-20190411.142401-3.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderCredentials(new \StructType\Credentials());
$get->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for getSessionId operation/method
 */
if ($get->getSessionId(new \StructType\GetSessionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMetadata operation/method
 */
if ($get->getMetadata(new \StructType\GetMetadata()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExtendedMetadata operation/method
 */
if ($get->getExtendedMetadata(new \StructType\GetExtendedMetadata()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExtendedMetadataText operation/method
 */
if ($get->getExtendedMetadataText(new \StructType\GetExtendedMetadataText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserInfo operation/method
 */
if ($get->getUserInfo(new \StructType\GetUserInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMediaMetadata operation/method
 */
if ($get->getMediaMetadata(new \StructType\GetMediaMetadata()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMediaURI operation/method
 */
if ($get->getMediaURI(new \StructType\GetMediaURI()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getScrollIndices operation/method
 */
if ($get->getScrollIndices(new \StructType\GetScrollIndices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLastUpdate operation/method
 */
if ($get->getLastUpdate(new \StructType\GetLastUpdate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAppLink operation/method
 */
if ($get->getAppLink(new \StructType\GetAppLink()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeviceLinkCode operation/method
 */
if ($get->getDeviceLinkCode(new \StructType\GetDeviceLinkCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeviceAuthToken operation/method
 */
if ($get->getDeviceAuthToken(new \StructType\GetDeviceAuthToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContentKey operation/method
 */
if ($get->getContentKey(new \StructType\GetContentKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Rate ServiceType
 */
$rate = new \ServiceType\Rate($options);
$rate->setSoapHeaderCredentials(new \StructType\Credentials());
$rate->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for rateItem operation/method
 */
if ($rate->rateItem(new \StructType\RateItem()) !== false) {
    print_r($rate->getResult());
} else {
    print_r($rate->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
$search->setSoapHeaderCredentials(new \StructType\Credentials());
$search->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for search operation/method
 */
if ($search->search(new \StructType\Search()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderCredentials(new \StructType\Credentials());
$create->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for createItem operation/method
 */
if ($create->createItem(new \StructType\CreateItem()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createContainer operation/method
 */
if ($create->createContainer(new \StructType\CreateContainer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderCredentials(new \StructType\Credentials());
$delete->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for deleteItem operation/method
 */
if ($delete->deleteItem(new \StructType\DeleteItem()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteContainer operation/method
 */
if ($delete->deleteContainer(new \StructType\DeleteContainer()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \ServiceType\Report($options);
$report->setSoapHeaderCredentials(new \StructType\Credentials());
$report->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for reportStatus operation/method
 */
if ($report->reportStatus(new \StructType\ReportStatus()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for reportPlaySeconds operation/method
 */
if ($report->reportPlaySeconds(new \StructType\ReportPlaySeconds()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for reportPlayStatus operation/method
 */
if ($report->reportPlayStatus(new \StructType\ReportPlayStatus()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for reportAccountAction operation/method
 */
if ($report->reportAccountAction(new \StructType\ReportAccountAction()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderCredentials(new \StructType\Credentials());
$set->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for setPlayedSeconds operation/method
 */
if ($set->setPlayedSeconds(new \StructType\SetPlayedSeconds()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \ServiceType\Refresh($options);
$refresh->setSoapHeaderCredentials(new \StructType\Credentials());
$refresh->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for refreshAuthToken operation/method
 */
if ($refresh->refreshAuthToken(new \StructType\RefreshAuthToken()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderCredentials(new \StructType\Credentials());
$add->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for addToContainer operation/method
 */
if ($add->addToContainer(new \StructType\AddToContainer()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Rename ServiceType
 */
$rename = new \ServiceType\Rename($options);
$rename->setSoapHeaderCredentials(new \StructType\Credentials());
$rename->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for renameContainer operation/method
 */
if ($rename->renameContainer(new \StructType\RenameContainer()) !== false) {
    print_r($rename->getResult());
} else {
    print_r($rename->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderCredentials(new \StructType\Credentials());
$remove->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for removeFromContainer operation/method
 */
if ($remove->removeFromContainer(new \StructType\RemoveFromContainer()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Reorder ServiceType
 */
$reorder = new \ServiceType\Reorder($options);
$reorder->setSoapHeaderCredentials(new \StructType\Credentials());
$reorder->setSoapHeaderContext(new \StructType\Context());
/**
 * Sample call for reorderContainer operation/method
 */
if ($reorder->reorderContainer(new \StructType\ReorderContainer()) !== false) {
    print_r($reorder->getResult());
} else {
    print_r($reorder->getLastError());
}
