<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackMetadata StructType
 * @subpackage Structs
 */
class TrackMetadata extends AbstractStructBase
{
    /**
     * The artistId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $artistId;
    /**
     * The artist
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $artist;
    /**
     * The composerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $composerId;
    /**
     * The composer
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $composer;
    /**
     * The albumArtistId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $albumArtistId;
    /**
     * The albumArtist
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $albumArtist;
    /**
     * The albumId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $albumId;
    /**
     * The album
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $album;
    /**
     * The authorId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorId;
    /**
     * The author
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $author;
    /**
     * The narratorId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $narratorId;
    /**
     * The narrator
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $narrator;
    /**
     * The bookId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bookId;
    /**
     * The book
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $book;
    /**
     * The producerId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $producerId;
    /**
     * The producer
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $producer;
    /**
     * The podcastId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $podcastId;
    /**
     * The podcast
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $podcast;
    /**
     * The hostId
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostId;
    /**
     * The host
     * Meta information extracted from the WSDL
     * - choice: artistId | artist | composerId | composer | albumArtistId | albumArtist | albumId | album | authorId | author | narratorId | narrator | bookId | book | producerId | producer | podcastId | podcast | hostId | host
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $host;
    /**
     * The genreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $genreId;
    /**
     * The genre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $genre;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The rating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rating;
    /**
     * The albumArtURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlbumArtUrl
     */
    public $albumArtURI;
    /**
     * The trackNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $trackNumber;
    /**
     * The canPlay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canPlay;
    /**
     * The canSkip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canSkip;
    /**
     * The canAddToFavorites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canAddToFavorites;
    /**
     * The canResume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canResume;
    /**
     * The canSeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canSeek;
    /**
     * Constructor method for trackMetadata
     * @uses TrackMetadata::setArtistId()
     * @uses TrackMetadata::setArtist()
     * @uses TrackMetadata::setComposerId()
     * @uses TrackMetadata::setComposer()
     * @uses TrackMetadata::setAlbumArtistId()
     * @uses TrackMetadata::setAlbumArtist()
     * @uses TrackMetadata::setAlbumId()
     * @uses TrackMetadata::setAlbum()
     * @uses TrackMetadata::setAuthorId()
     * @uses TrackMetadata::setAuthor()
     * @uses TrackMetadata::setNarratorId()
     * @uses TrackMetadata::setNarrator()
     * @uses TrackMetadata::setBookId()
     * @uses TrackMetadata::setBook()
     * @uses TrackMetadata::setProducerId()
     * @uses TrackMetadata::setProducer()
     * @uses TrackMetadata::setPodcastId()
     * @uses TrackMetadata::setPodcast()
     * @uses TrackMetadata::setHostId()
     * @uses TrackMetadata::setHost()
     * @uses TrackMetadata::setGenreId()
     * @uses TrackMetadata::setGenre()
     * @uses TrackMetadata::setDuration()
     * @uses TrackMetadata::setRating()
     * @uses TrackMetadata::setAlbumArtURI()
     * @uses TrackMetadata::setTrackNumber()
     * @uses TrackMetadata::setCanPlay()
     * @uses TrackMetadata::setCanSkip()
     * @uses TrackMetadata::setCanAddToFavorites()
     * @uses TrackMetadata::setCanResume()
     * @uses TrackMetadata::setCanSeek()
     * @param string $artistId
     * @param string $artist
     * @param string $composerId
     * @param string $composer
     * @param string $albumArtistId
     * @param string $albumArtist
     * @param string $albumId
     * @param string $album
     * @param string $authorId
     * @param string $author
     * @param string $narratorId
     * @param string $narrator
     * @param string $bookId
     * @param string $book
     * @param string $producerId
     * @param string $producer
     * @param string $podcastId
     * @param string $podcast
     * @param string $hostId
     * @param string $host
     * @param string $genreId
     * @param string $genre
     * @param int $duration
     * @param int $rating
     * @param \StructType\AlbumArtUrl $albumArtURI
     * @param int $trackNumber
     * @param bool $canPlay
     * @param bool $canSkip
     * @param bool $canAddToFavorites
     * @param bool $canResume
     * @param bool $canSeek
     */
    public function __construct($artistId = null, $artist = null, $composerId = null, $composer = null, $albumArtistId = null, $albumArtist = null, $albumId = null, $album = null, $authorId = null, $author = null, $narratorId = null, $narrator = null, $bookId = null, $book = null, $producerId = null, $producer = null, $podcastId = null, $podcast = null, $hostId = null, $host = null, $genreId = null, $genre = null, $duration = null, $rating = null, \StructType\AlbumArtUrl $albumArtURI = null, $trackNumber = null, $canPlay = null, $canSkip = null, $canAddToFavorites = null, $canResume = null, $canSeek = null)
    {
        $this
            ->setArtistId($artistId)
            ->setArtist($artist)
            ->setComposerId($composerId)
            ->setComposer($composer)
            ->setAlbumArtistId($albumArtistId)
            ->setAlbumArtist($albumArtist)
            ->setAlbumId($albumId)
            ->setAlbum($album)
            ->setAuthorId($authorId)
            ->setAuthor($author)
            ->setNarratorId($narratorId)
            ->setNarrator($narrator)
            ->setBookId($bookId)
            ->setBook($book)
            ->setProducerId($producerId)
            ->setProducer($producer)
            ->setPodcastId($podcastId)
            ->setPodcast($podcast)
            ->setHostId($hostId)
            ->setHost($host)
            ->setGenreId($genreId)
            ->setGenre($genre)
            ->setDuration($duration)
            ->setRating($rating)
            ->setAlbumArtURI($albumArtURI)
            ->setTrackNumber($trackNumber)
            ->setCanPlay($canPlay)
            ->setCanSkip($canSkip)
            ->setCanAddToFavorites($canAddToFavorites)
            ->setCanResume($canResume)
            ->setCanSeek($canSeek);
    }
    /**
     * Get artistId value
     * @return string|null
     */
    public function getArtistId()
    {
        return isset($this->artistId) ? $this->artistId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setArtistId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtistId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateArtistIdForChoiceConstraintsFromSetArtistId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property artistId can\'t be set as the property %s is already set. Only one property must be set among these properties: artistId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set artistId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $artistId
     * @return \StructType\TrackMetadata
     */
    public function setArtistId($artistId = null)
    {
        // validation for constraint: string
        if (!is_null($artistId) && !is_string($artistId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artistId, true), gettype($artistId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($artistIdChoiceErrorMessage = self::validateArtistIdForChoiceConstraintsFromSetArtistId($artistId))) {
            throw new \InvalidArgumentException($artistIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($artistId) && mb_strlen($artistId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($artistId)), __LINE__);
        }
        if (is_null($artistId) || (is_array($artistId) && empty($artistId))) {
            unset($this->artistId);
        } else {
            $this->artistId = $artistId;
        }
        return $this;
    }
    /**
     * Get artist value
     * @return string|null
     */
    public function getArtist()
    {
        return isset($this->artist) ? $this->artist : null;
    }
    /**
     * This method is responsible for validating the value passed to the setArtist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtist method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateArtistForChoiceConstraintsFromSetArtist($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property artist can\'t be set as the property %s is already set. Only one property must be set among these properties: artist, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set artist value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $artist
     * @return \StructType\TrackMetadata
     */
    public function setArtist($artist = null)
    {
        // validation for constraint: string
        if (!is_null($artist) && !is_string($artist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artist, true), gettype($artist)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($artistChoiceErrorMessage = self::validateArtistForChoiceConstraintsFromSetArtist($artist))) {
            throw new \InvalidArgumentException($artistChoiceErrorMessage, __LINE__);
        }
        if (is_null($artist) || (is_array($artist) && empty($artist))) {
            unset($this->artist);
        } else {
            $this->artist = $artist;
        }
        return $this;
    }
    /**
     * Get composerId value
     * @return string|null
     */
    public function getComposerId()
    {
        return isset($this->composerId) ? $this->composerId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setComposerId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComposerId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateComposerIdForChoiceConstraintsFromSetComposerId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property composerId can\'t be set as the property %s is already set. Only one property must be set among these properties: composerId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set composerId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $composerId
     * @return \StructType\TrackMetadata
     */
    public function setComposerId($composerId = null)
    {
        // validation for constraint: string
        if (!is_null($composerId) && !is_string($composerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($composerId, true), gettype($composerId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($composerIdChoiceErrorMessage = self::validateComposerIdForChoiceConstraintsFromSetComposerId($composerId))) {
            throw new \InvalidArgumentException($composerIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($composerId) && mb_strlen($composerId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($composerId)), __LINE__);
        }
        if (is_null($composerId) || (is_array($composerId) && empty($composerId))) {
            unset($this->composerId);
        } else {
            $this->composerId = $composerId;
        }
        return $this;
    }
    /**
     * Get composer value
     * @return string|null
     */
    public function getComposer()
    {
        return isset($this->composer) ? $this->composer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setComposer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComposer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateComposerForChoiceConstraintsFromSetComposer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property composer can\'t be set as the property %s is already set. Only one property must be set among these properties: composer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set composer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $composer
     * @return \StructType\TrackMetadata
     */
    public function setComposer($composer = null)
    {
        // validation for constraint: string
        if (!is_null($composer) && !is_string($composer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($composer, true), gettype($composer)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($composerChoiceErrorMessage = self::validateComposerForChoiceConstraintsFromSetComposer($composer))) {
            throw new \InvalidArgumentException($composerChoiceErrorMessage, __LINE__);
        }
        if (is_null($composer) || (is_array($composer) && empty($composer))) {
            unset($this->composer);
        } else {
            $this->composer = $composer;
        }
        return $this;
    }
    /**
     * Get albumArtistId value
     * @return string|null
     */
    public function getAlbumArtistId()
    {
        return isset($this->albumArtistId) ? $this->albumArtistId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAlbumArtistId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlbumArtistId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAlbumArtistIdForChoiceConstraintsFromSetAlbumArtistId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property albumArtistId can\'t be set as the property %s is already set. Only one property must be set among these properties: albumArtistId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set albumArtistId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $albumArtistId
     * @return \StructType\TrackMetadata
     */
    public function setAlbumArtistId($albumArtistId = null)
    {
        // validation for constraint: string
        if (!is_null($albumArtistId) && !is_string($albumArtistId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($albumArtistId, true), gettype($albumArtistId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($albumArtistIdChoiceErrorMessage = self::validateAlbumArtistIdForChoiceConstraintsFromSetAlbumArtistId($albumArtistId))) {
            throw new \InvalidArgumentException($albumArtistIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($albumArtistId) && mb_strlen($albumArtistId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($albumArtistId)), __LINE__);
        }
        if (is_null($albumArtistId) || (is_array($albumArtistId) && empty($albumArtistId))) {
            unset($this->albumArtistId);
        } else {
            $this->albumArtistId = $albumArtistId;
        }
        return $this;
    }
    /**
     * Get albumArtist value
     * @return string|null
     */
    public function getAlbumArtist()
    {
        return isset($this->albumArtist) ? $this->albumArtist : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAlbumArtist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlbumArtist method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAlbumArtistForChoiceConstraintsFromSetAlbumArtist($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property albumArtist can\'t be set as the property %s is already set. Only one property must be set among these properties: albumArtist, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set albumArtist value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $albumArtist
     * @return \StructType\TrackMetadata
     */
    public function setAlbumArtist($albumArtist = null)
    {
        // validation for constraint: string
        if (!is_null($albumArtist) && !is_string($albumArtist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($albumArtist, true), gettype($albumArtist)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($albumArtistChoiceErrorMessage = self::validateAlbumArtistForChoiceConstraintsFromSetAlbumArtist($albumArtist))) {
            throw new \InvalidArgumentException($albumArtistChoiceErrorMessage, __LINE__);
        }
        if (is_null($albumArtist) || (is_array($albumArtist) && empty($albumArtist))) {
            unset($this->albumArtist);
        } else {
            $this->albumArtist = $albumArtist;
        }
        return $this;
    }
    /**
     * Get albumId value
     * @return string|null
     */
    public function getAlbumId()
    {
        return isset($this->albumId) ? $this->albumId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAlbumId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlbumId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAlbumIdForChoiceConstraintsFromSetAlbumId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property albumId can\'t be set as the property %s is already set. Only one property must be set among these properties: albumId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set albumId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $albumId
     * @return \StructType\TrackMetadata
     */
    public function setAlbumId($albumId = null)
    {
        // validation for constraint: string
        if (!is_null($albumId) && !is_string($albumId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($albumId, true), gettype($albumId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($albumIdChoiceErrorMessage = self::validateAlbumIdForChoiceConstraintsFromSetAlbumId($albumId))) {
            throw new \InvalidArgumentException($albumIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($albumId) && mb_strlen($albumId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($albumId)), __LINE__);
        }
        if (is_null($albumId) || (is_array($albumId) && empty($albumId))) {
            unset($this->albumId);
        } else {
            $this->albumId = $albumId;
        }
        return $this;
    }
    /**
     * Get album value
     * @return string|null
     */
    public function getAlbum()
    {
        return isset($this->album) ? $this->album : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAlbum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlbum method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAlbumForChoiceConstraintsFromSetAlbum($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property album can\'t be set as the property %s is already set. Only one property must be set among these properties: album, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set album value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $album
     * @return \StructType\TrackMetadata
     */
    public function setAlbum($album = null)
    {
        // validation for constraint: string
        if (!is_null($album) && !is_string($album)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($album, true), gettype($album)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($albumChoiceErrorMessage = self::validateAlbumForChoiceConstraintsFromSetAlbum($album))) {
            throw new \InvalidArgumentException($albumChoiceErrorMessage, __LINE__);
        }
        if (is_null($album) || (is_array($album) && empty($album))) {
            unset($this->album);
        } else {
            $this->album = $album;
        }
        return $this;
    }
    /**
     * Get authorId value
     * @return string|null
     */
    public function getAuthorId()
    {
        return isset($this->authorId) ? $this->authorId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthorId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorIdForChoiceConstraintsFromSetAuthorId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property authorId can\'t be set as the property %s is already set. Only one property must be set among these properties: authorId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set authorId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $authorId
     * @return \StructType\TrackMetadata
     */
    public function setAuthorId($authorId = null)
    {
        // validation for constraint: string
        if (!is_null($authorId) && !is_string($authorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorId, true), gettype($authorId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($authorIdChoiceErrorMessage = self::validateAuthorIdForChoiceConstraintsFromSetAuthorId($authorId))) {
            throw new \InvalidArgumentException($authorIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($authorId) || (is_array($authorId) && empty($authorId))) {
            unset($this->authorId);
        } else {
            $this->authorId = $authorId;
        }
        return $this;
    }
    /**
     * Get author value
     * @return string|null
     */
    public function getAuthor()
    {
        return isset($this->author) ? $this->author : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthor method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorForChoiceConstraintsFromSetAuthor($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property author can\'t be set as the property %s is already set. Only one property must be set among these properties: author, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set author value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $author
     * @return \StructType\TrackMetadata
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($authorChoiceErrorMessage = self::validateAuthorForChoiceConstraintsFromSetAuthor($author))) {
            throw new \InvalidArgumentException($authorChoiceErrorMessage, __LINE__);
        }
        if (is_null($author) || (is_array($author) && empty($author))) {
            unset($this->author);
        } else {
            $this->author = $author;
        }
        return $this;
    }
    /**
     * Get narratorId value
     * @return string|null
     */
    public function getNarratorId()
    {
        return isset($this->narratorId) ? $this->narratorId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNarratorId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNarratorId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNarratorIdForChoiceConstraintsFromSetNarratorId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property narratorId can\'t be set as the property %s is already set. Only one property must be set among these properties: narratorId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set narratorId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $narratorId
     * @return \StructType\TrackMetadata
     */
    public function setNarratorId($narratorId = null)
    {
        // validation for constraint: string
        if (!is_null($narratorId) && !is_string($narratorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narratorId, true), gettype($narratorId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($narratorIdChoiceErrorMessage = self::validateNarratorIdForChoiceConstraintsFromSetNarratorId($narratorId))) {
            throw new \InvalidArgumentException($narratorIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($narratorId) || (is_array($narratorId) && empty($narratorId))) {
            unset($this->narratorId);
        } else {
            $this->narratorId = $narratorId;
        }
        return $this;
    }
    /**
     * Get narrator value
     * @return string|null
     */
    public function getNarrator()
    {
        return isset($this->narrator) ? $this->narrator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNarrator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNarrator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNarratorForChoiceConstraintsFromSetNarrator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property narrator can\'t be set as the property %s is already set. Only one property must be set among these properties: narrator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set narrator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $narrator
     * @return \StructType\TrackMetadata
     */
    public function setNarrator($narrator = null)
    {
        // validation for constraint: string
        if (!is_null($narrator) && !is_string($narrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narrator, true), gettype($narrator)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($narratorChoiceErrorMessage = self::validateNarratorForChoiceConstraintsFromSetNarrator($narrator))) {
            throw new \InvalidArgumentException($narratorChoiceErrorMessage, __LINE__);
        }
        if (is_null($narrator) || (is_array($narrator) && empty($narrator))) {
            unset($this->narrator);
        } else {
            $this->narrator = $narrator;
        }
        return $this;
    }
    /**
     * Get bookId value
     * @return string|null
     */
    public function getBookId()
    {
        return isset($this->bookId) ? $this->bookId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBookId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBookIdForChoiceConstraintsFromSetBookId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property bookId can\'t be set as the property %s is already set. Only one property must be set among these properties: bookId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set bookId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $bookId
     * @return \StructType\TrackMetadata
     */
    public function setBookId($bookId = null)
    {
        // validation for constraint: string
        if (!is_null($bookId) && !is_string($bookId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookId, true), gettype($bookId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($bookIdChoiceErrorMessage = self::validateBookIdForChoiceConstraintsFromSetBookId($bookId))) {
            throw new \InvalidArgumentException($bookIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($bookId) || (is_array($bookId) && empty($bookId))) {
            unset($this->bookId);
        } else {
            $this->bookId = $bookId;
        }
        return $this;
    }
    /**
     * Get book value
     * @return string|null
     */
    public function getBook()
    {
        return isset($this->book) ? $this->book : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBook method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBookForChoiceConstraintsFromSetBook($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property book can\'t be set as the property %s is already set. Only one property must be set among these properties: book, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set book value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $book
     * @return \StructType\TrackMetadata
     */
    public function setBook($book = null)
    {
        // validation for constraint: string
        if (!is_null($book) && !is_string($book)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($book, true), gettype($book)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($bookChoiceErrorMessage = self::validateBookForChoiceConstraintsFromSetBook($book))) {
            throw new \InvalidArgumentException($bookChoiceErrorMessage, __LINE__);
        }
        if (is_null($book) || (is_array($book) && empty($book))) {
            unset($this->book);
        } else {
            $this->book = $book;
        }
        return $this;
    }
    /**
     * Get producerId value
     * @return string|null
     */
    public function getProducerId()
    {
        return isset($this->producerId) ? $this->producerId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProducerId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducerId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProducerIdForChoiceConstraintsFromSetProducerId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property producerId can\'t be set as the property %s is already set. Only one property must be set among these properties: producerId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set producerId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $producerId
     * @return \StructType\TrackMetadata
     */
    public function setProducerId($producerId = null)
    {
        // validation for constraint: string
        if (!is_null($producerId) && !is_string($producerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producerId, true), gettype($producerId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($producerIdChoiceErrorMessage = self::validateProducerIdForChoiceConstraintsFromSetProducerId($producerId))) {
            throw new \InvalidArgumentException($producerIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($producerId) || (is_array($producerId) && empty($producerId))) {
            unset($this->producerId);
        } else {
            $this->producerId = $producerId;
        }
        return $this;
    }
    /**
     * Get producer value
     * @return string|null
     */
    public function getProducer()
    {
        return isset($this->producer) ? $this->producer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProducer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProducerForChoiceConstraintsFromSetProducer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'podcastId',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property producer can\'t be set as the property %s is already set. Only one property must be set among these properties: producer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set producer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $producer
     * @return \StructType\TrackMetadata
     */
    public function setProducer($producer = null)
    {
        // validation for constraint: string
        if (!is_null($producer) && !is_string($producer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producer, true), gettype($producer)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($producerChoiceErrorMessage = self::validateProducerForChoiceConstraintsFromSetProducer($producer))) {
            throw new \InvalidArgumentException($producerChoiceErrorMessage, __LINE__);
        }
        if (is_null($producer) || (is_array($producer) && empty($producer))) {
            unset($this->producer);
        } else {
            $this->producer = $producer;
        }
        return $this;
    }
    /**
     * Get podcastId value
     * @return string|null
     */
    public function getPodcastId()
    {
        return isset($this->podcastId) ? $this->podcastId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPodcastId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPodcastId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePodcastIdForChoiceConstraintsFromSetPodcastId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcast',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property podcastId can\'t be set as the property %s is already set. Only one property must be set among these properties: podcastId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set podcastId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $podcastId
     * @return \StructType\TrackMetadata
     */
    public function setPodcastId($podcastId = null)
    {
        // validation for constraint: string
        if (!is_null($podcastId) && !is_string($podcastId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podcastId, true), gettype($podcastId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($podcastIdChoiceErrorMessage = self::validatePodcastIdForChoiceConstraintsFromSetPodcastId($podcastId))) {
            throw new \InvalidArgumentException($podcastIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($podcastId) || (is_array($podcastId) && empty($podcastId))) {
            unset($this->podcastId);
        } else {
            $this->podcastId = $podcastId;
        }
        return $this;
    }
    /**
     * Get podcast value
     * @return string|null
     */
    public function getPodcast()
    {
        return isset($this->podcast) ? $this->podcast : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPodcast method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPodcast method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePodcastForChoiceConstraintsFromSetPodcast($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'hostId',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property podcast can\'t be set as the property %s is already set. Only one property must be set among these properties: podcast, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set podcast value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $podcast
     * @return \StructType\TrackMetadata
     */
    public function setPodcast($podcast = null)
    {
        // validation for constraint: string
        if (!is_null($podcast) && !is_string($podcast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podcast, true), gettype($podcast)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($podcastChoiceErrorMessage = self::validatePodcastForChoiceConstraintsFromSetPodcast($podcast))) {
            throw new \InvalidArgumentException($podcastChoiceErrorMessage, __LINE__);
        }
        if (is_null($podcast) || (is_array($podcast) && empty($podcast))) {
            unset($this->podcast);
        } else {
            $this->podcast = $podcast;
        }
        return $this;
    }
    /**
     * Get hostId value
     * @return string|null
     */
    public function getHostId()
    {
        return isset($this->hostId) ? $this->hostId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHostId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHostId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHostIdForChoiceConstraintsFromSetHostId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'host',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property hostId can\'t be set as the property %s is already set. Only one property must be set among these properties: hostId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set hostId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $hostId
     * @return \StructType\TrackMetadata
     */
    public function setHostId($hostId = null)
    {
        // validation for constraint: string
        if (!is_null($hostId) && !is_string($hostId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostId, true), gettype($hostId)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($hostIdChoiceErrorMessage = self::validateHostIdForChoiceConstraintsFromSetHostId($hostId))) {
            throw new \InvalidArgumentException($hostIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($hostId) || (is_array($hostId) && empty($hostId))) {
            unset($this->hostId);
        } else {
            $this->hostId = $hostId;
        }
        return $this;
    }
    /**
     * Get host value
     * @return string|null
     */
    public function getHost()
    {
        return isset($this->host) ? $this->host : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHost method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHostForChoiceConstraintsFromSetHost($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'artist',
            'composerId',
            'composer',
            'albumArtistId',
            'albumArtist',
            'albumId',
            'album',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'bookId',
            'book',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
            'hostId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property host can\'t be set as the property %s is already set. Only one property must be set among these properties: host, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set host value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $host
     * @return \StructType\TrackMetadata
     */
    public function setHost($host = null)
    {
        // validation for constraint: string
        if (!is_null($host) && !is_string($host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($host, true), gettype($host)), __LINE__);
        }
        // validation for constraint: choice(artistId, artist, composerId, composer, albumArtistId, albumArtist, albumId, album, authorId, author, narratorId, narrator, bookId, book, producerId, producer, podcastId, podcast, hostId, host)
        if ('' !== ($hostChoiceErrorMessage = self::validateHostForChoiceConstraintsFromSetHost($host))) {
            throw new \InvalidArgumentException($hostChoiceErrorMessage, __LINE__);
        }
        if (is_null($host) || (is_array($host) && empty($host))) {
            unset($this->host);
        } else {
            $this->host = $host;
        }
        return $this;
    }
    /**
     * Get genreId value
     * @return string|null
     */
    public function getGenreId()
    {
        return $this->genreId;
    }
    /**
     * Set genreId value
     * @param string $genreId
     * @return \StructType\TrackMetadata
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($genreId) && mb_strlen($genreId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($genreId)), __LINE__);
        }
        $this->genreId = $genreId;
        return $this;
    }
    /**
     * Get genre value
     * @return string|null
     */
    public function getGenre()
    {
        return $this->genre;
    }
    /**
     * Set genre value
     * @param string $genre
     * @return \StructType\TrackMetadata
     */
    public function setGenre($genre = null)
    {
        // validation for constraint: string
        if (!is_null($genre) && !is_string($genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genre, true), gettype($genre)), __LINE__);
        }
        $this->genre = $genre;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\TrackMetadata
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get rating value
     * @return int|null
     */
    public function getRating()
    {
        return $this->rating;
    }
    /**
     * Set rating value
     * @param int $rating
     * @return \StructType\TrackMetadata
     */
    public function setRating($rating = null)
    {
        // validation for constraint: int
        if (!is_null($rating) && !(is_int($rating) || ctype_digit($rating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->rating = $rating;
        return $this;
    }
    /**
     * Get albumArtURI value
     * @return \StructType\AlbumArtUrl|null
     */
    public function getAlbumArtURI()
    {
        return $this->albumArtURI;
    }
    /**
     * Set albumArtURI value
     * @param \StructType\AlbumArtUrl $albumArtURI
     * @return \StructType\TrackMetadata
     */
    public function setAlbumArtURI(\StructType\AlbumArtUrl $albumArtURI = null)
    {
        $this->albumArtURI = $albumArtURI;
        return $this;
    }
    /**
     * Get trackNumber value
     * @return int|null
     */
    public function getTrackNumber()
    {
        return $this->trackNumber;
    }
    /**
     * Set trackNumber value
     * @param int $trackNumber
     * @return \StructType\TrackMetadata
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: int
        if (!is_null($trackNumber) && !(is_int($trackNumber) || ctype_digit($trackNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trackNumber, true), gettype($trackNumber)), __LINE__);
        }
        $this->trackNumber = $trackNumber;
        return $this;
    }
    /**
     * Get canPlay value
     * @return bool|null
     */
    public function getCanPlay()
    {
        return $this->canPlay;
    }
    /**
     * Set canPlay value
     * @param bool $canPlay
     * @return \StructType\TrackMetadata
     */
    public function setCanPlay($canPlay = null)
    {
        // validation for constraint: boolean
        if (!is_null($canPlay) && !is_bool($canPlay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canPlay, true), gettype($canPlay)), __LINE__);
        }
        $this->canPlay = $canPlay;
        return $this;
    }
    /**
     * Get canSkip value
     * @return bool|null
     */
    public function getCanSkip()
    {
        return $this->canSkip;
    }
    /**
     * Set canSkip value
     * @param bool $canSkip
     * @return \StructType\TrackMetadata
     */
    public function setCanSkip($canSkip = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSkip) && !is_bool($canSkip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSkip, true), gettype($canSkip)), __LINE__);
        }
        $this->canSkip = $canSkip;
        return $this;
    }
    /**
     * Get canAddToFavorites value
     * @return bool|null
     */
    public function getCanAddToFavorites()
    {
        return $this->canAddToFavorites;
    }
    /**
     * Set canAddToFavorites value
     * @param bool $canAddToFavorites
     * @return \StructType\TrackMetadata
     */
    public function setCanAddToFavorites($canAddToFavorites = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAddToFavorites) && !is_bool($canAddToFavorites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAddToFavorites, true), gettype($canAddToFavorites)), __LINE__);
        }
        $this->canAddToFavorites = $canAddToFavorites;
        return $this;
    }
    /**
     * Get canResume value
     * @return bool|null
     */
    public function getCanResume()
    {
        return $this->canResume;
    }
    /**
     * Set canResume value
     * @param bool $canResume
     * @return \StructType\TrackMetadata
     */
    public function setCanResume($canResume = null)
    {
        // validation for constraint: boolean
        if (!is_null($canResume) && !is_bool($canResume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canResume, true), gettype($canResume)), __LINE__);
        }
        $this->canResume = $canResume;
        return $this;
    }
    /**
     * Get canSeek value
     * @return bool|null
     */
    public function getCanSeek()
    {
        return $this->canSeek;
    }
    /**
     * Set canSeek value
     * @param bool $canSeek
     * @return \StructType\TrackMetadata
     */
    public function setCanSeek($canSeek = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSeek) && !is_bool($canSeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSeek, true), gettype($canSeek)), __LINE__);
        }
        $this->canSeek = $canSeek;
        return $this;
    }
}
