<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for streamMetadata StructType
 * @subpackage Structs
 */
class StreamMetadata extends AbstractStructBase
{
    /**
     * The currentHost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentHost;
    /**
     * The currentShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $currentShowId;
    /**
     * The currentShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentShow;
    /**
     * The secondsRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $secondsRemaining;
    /**
     * The secondsToNextShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $secondsToNextShow;
    /**
     * The bitrate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bitrate;
    /**
     * The logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlbumArtUrl
     */
    public $logo;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isEphemeral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEphemeral;
    /**
     * Constructor method for streamMetadata
     * @uses StreamMetadata::setCurrentHost()
     * @uses StreamMetadata::setCurrentShowId()
     * @uses StreamMetadata::setCurrentShow()
     * @uses StreamMetadata::setSecondsRemaining()
     * @uses StreamMetadata::setSecondsToNextShow()
     * @uses StreamMetadata::setBitrate()
     * @uses StreamMetadata::setLogo()
     * @uses StreamMetadata::setDescription()
     * @uses StreamMetadata::setIsEphemeral()
     * @param string $currentHost
     * @param string $currentShowId
     * @param string $currentShow
     * @param int $secondsRemaining
     * @param int $secondsToNextShow
     * @param int $bitrate
     * @param \StructType\AlbumArtUrl $logo
     * @param string $description
     * @param bool $isEphemeral
     */
    public function __construct($currentHost = null, $currentShowId = null, $currentShow = null, $secondsRemaining = null, $secondsToNextShow = null, $bitrate = null, \StructType\AlbumArtUrl $logo = null, $description = null, $isEphemeral = null)
    {
        $this
            ->setCurrentHost($currentHost)
            ->setCurrentShowId($currentShowId)
            ->setCurrentShow($currentShow)
            ->setSecondsRemaining($secondsRemaining)
            ->setSecondsToNextShow($secondsToNextShow)
            ->setBitrate($bitrate)
            ->setLogo($logo)
            ->setDescription($description)
            ->setIsEphemeral($isEphemeral);
    }
    /**
     * Get currentHost value
     * @return string|null
     */
    public function getCurrentHost()
    {
        return $this->currentHost;
    }
    /**
     * Set currentHost value
     * @param string $currentHost
     * @return \StructType\StreamMetadata
     */
    public function setCurrentHost($currentHost = null)
    {
        // validation for constraint: string
        if (!is_null($currentHost) && !is_string($currentHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentHost, true), gettype($currentHost)), __LINE__);
        }
        $this->currentHost = $currentHost;
        return $this;
    }
    /**
     * Get currentShowId value
     * @return string|null
     */
    public function getCurrentShowId()
    {
        return $this->currentShowId;
    }
    /**
     * Set currentShowId value
     * @param string $currentShowId
     * @return \StructType\StreamMetadata
     */
    public function setCurrentShowId($currentShowId = null)
    {
        // validation for constraint: string
        if (!is_null($currentShowId) && !is_string($currentShowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentShowId, true), gettype($currentShowId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($currentShowId) && mb_strlen($currentShowId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($currentShowId)), __LINE__);
        }
        $this->currentShowId = $currentShowId;
        return $this;
    }
    /**
     * Get currentShow value
     * @return string|null
     */
    public function getCurrentShow()
    {
        return $this->currentShow;
    }
    /**
     * Set currentShow value
     * @param string $currentShow
     * @return \StructType\StreamMetadata
     */
    public function setCurrentShow($currentShow = null)
    {
        // validation for constraint: string
        if (!is_null($currentShow) && !is_string($currentShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentShow, true), gettype($currentShow)), __LINE__);
        }
        $this->currentShow = $currentShow;
        return $this;
    }
    /**
     * Get secondsRemaining value
     * @return int|null
     */
    public function getSecondsRemaining()
    {
        return $this->secondsRemaining;
    }
    /**
     * Set secondsRemaining value
     * @param int $secondsRemaining
     * @return \StructType\StreamMetadata
     */
    public function setSecondsRemaining($secondsRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($secondsRemaining) && !(is_int($secondsRemaining) || ctype_digit($secondsRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secondsRemaining, true), gettype($secondsRemaining)), __LINE__);
        }
        $this->secondsRemaining = $secondsRemaining;
        return $this;
    }
    /**
     * Get secondsToNextShow value
     * @return int|null
     */
    public function getSecondsToNextShow()
    {
        return $this->secondsToNextShow;
    }
    /**
     * Set secondsToNextShow value
     * @param int $secondsToNextShow
     * @return \StructType\StreamMetadata
     */
    public function setSecondsToNextShow($secondsToNextShow = null)
    {
        // validation for constraint: int
        if (!is_null($secondsToNextShow) && !(is_int($secondsToNextShow) || ctype_digit($secondsToNextShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secondsToNextShow, true), gettype($secondsToNextShow)), __LINE__);
        }
        $this->secondsToNextShow = $secondsToNextShow;
        return $this;
    }
    /**
     * Get bitrate value
     * @return int|null
     */
    public function getBitrate()
    {
        return $this->bitrate;
    }
    /**
     * Set bitrate value
     * @param int $bitrate
     * @return \StructType\StreamMetadata
     */
    public function setBitrate($bitrate = null)
    {
        // validation for constraint: int
        if (!is_null($bitrate) && !(is_int($bitrate) || ctype_digit($bitrate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bitrate, true), gettype($bitrate)), __LINE__);
        }
        $this->bitrate = $bitrate;
        return $this;
    }
    /**
     * Get logo value
     * @return \StructType\AlbumArtUrl|null
     */
    public function getLogo()
    {
        return $this->logo;
    }
    /**
     * Set logo value
     * @param \StructType\AlbumArtUrl $logo
     * @return \StructType\StreamMetadata
     */
    public function setLogo(\StructType\AlbumArtUrl $logo = null)
    {
        $this->logo = $logo;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\StreamMetadata
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isEphemeral value
     * @return bool|null
     */
    public function getIsEphemeral()
    {
        return $this->isEphemeral;
    }
    /**
     * Set isEphemeral value
     * @param bool $isEphemeral
     * @return \StructType\StreamMetadata
     */
    public function setIsEphemeral($isEphemeral = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEphemeral) && !is_bool($isEphemeral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEphemeral, true), gettype($isEphemeral)), __LINE__);
        }
        $this->isEphemeral = $isEphemeral;
        return $this;
    }
}
