<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simpleHttpRequestAction StructType
 * @subpackage Structs
 */
class SimpleHttpRequestAction extends AbstractStructBase
{
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * The method
     * @var string
     */
    public $method;
    /**
     * The httpHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HttpHeaders
     */
    public $httpHeaders;
    /**
     * The refreshOnSuccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $refreshOnSuccess;
    /**
     * Constructor method for simpleHttpRequestAction
     * @uses SimpleHttpRequestAction::setUrl()
     * @uses SimpleHttpRequestAction::setMethod()
     * @uses SimpleHttpRequestAction::setHttpHeaders()
     * @uses SimpleHttpRequestAction::setRefreshOnSuccess()
     * @param string $url
     * @param string $method
     * @param \StructType\HttpHeaders $httpHeaders
     * @param bool $refreshOnSuccess
     */
    public function __construct($url = null, $method = null, \StructType\HttpHeaders $httpHeaders = null, $refreshOnSuccess = null)
    {
        $this
            ->setUrl($url)
            ->setMethod($method)
            ->setHttpHeaders($httpHeaders)
            ->setRefreshOnSuccess($refreshOnSuccess);
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\SimpleHttpRequestAction
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \StructType\SimpleHttpRequestAction
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($method, true), gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get httpHeaders value
     * @return \StructType\HttpHeaders|null
     */
    public function getHttpHeaders()
    {
        return $this->httpHeaders;
    }
    /**
     * Set httpHeaders value
     * @param \StructType\HttpHeaders $httpHeaders
     * @return \StructType\SimpleHttpRequestAction
     */
    public function setHttpHeaders(\StructType\HttpHeaders $httpHeaders = null)
    {
        $this->httpHeaders = $httpHeaders;
        return $this;
    }
    /**
     * Get refreshOnSuccess value
     * @return bool|null
     */
    public function getRefreshOnSuccess()
    {
        return $this->refreshOnSuccess;
    }
    /**
     * Set refreshOnSuccess value
     * @param bool $refreshOnSuccess
     * @return \StructType\SimpleHttpRequestAction
     */
    public function setRefreshOnSuccess($refreshOnSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($refreshOnSuccess) && !is_bool($refreshOnSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refreshOnSuccess, true), gettype($refreshOnSuccess)), __LINE__);
        }
        $this->refreshOnSuccess = $refreshOnSuccess;
        return $this;
    }
}
