<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedPlay StructType
 * @subpackage Structs
 */
class RelatedPlay extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The itemType
     * Meta information extracted from the WSDL
     * - ref: tns:itemType
     * @var string
     */
    public $itemType;
    /**
     * The semanticType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:semanticType
     * @var string
     */
    public $semanticType;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The canPlay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canPlay;
    /**
     * Constructor method for relatedPlay
     * @uses RelatedPlay::setId()
     * @uses RelatedPlay::setItemType()
     * @uses RelatedPlay::setSemanticType()
     * @uses RelatedPlay::setTitle()
     * @uses RelatedPlay::setCanPlay()
     * @param string $id
     * @param string $itemType
     * @param string $semanticType
     * @param string $title
     * @param bool $canPlay
     */
    public function __construct($id = null, $itemType = null, $semanticType = null, $title = null, $canPlay = null)
    {
        $this
            ->setId($id)
            ->setItemType($itemType)
            ->setSemanticType($semanticType)
            ->setTitle($title)
            ->setCanPlay($canPlay);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RelatedPlay
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get itemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\RelatedPlay
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get semanticType value
     * @return string|null
     */
    public function getSemanticType()
    {
        return $this->semanticType;
    }
    /**
     * Set semanticType value
     * @uses \EnumType\SemanticType::valueIsValid()
     * @uses \EnumType\SemanticType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $semanticType
     * @return \StructType\RelatedPlay
     */
    public function setSemanticType($semanticType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SemanticType::valueIsValid($semanticType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SemanticType', is_array($semanticType) ? implode(', ', $semanticType) : var_export($semanticType, true), implode(', ', \EnumType\SemanticType::getValidValues())), __LINE__);
        }
        $this->semanticType = $semanticType;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\RelatedPlay
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get canPlay value
     * @return bool|null
     */
    public function getCanPlay()
    {
        return $this->canPlay;
    }
    /**
     * Set canPlay value
     * @param bool $canPlay
     * @return \StructType\RelatedPlay
     */
    public function setCanPlay($canPlay = null)
    {
        // validation for constraint: boolean
        if (!is_null($canPlay) && !is_bool($canPlay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canPlay, true), gettype($canPlay)), __LINE__);
        }
        $this->canPlay = $canPlay;
        return $this;
    }
}
