<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mediaList StructType
 * @subpackage Structs
 */
class MediaList extends AbstractStructBase
{
    /**
     * The index
     * @var int
     */
    public $index;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The total
     * @var int
     */
    public $total;
    /**
     * The positionInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionInformation
     */
    public $positionInformation;
    /**
     * The mediaCollection
     * Meta information extracted from the WSDL
     * - choice: mediaCollection | mediaMetadata
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \StructType\MediaCollection
     */
    public $mediaCollection;
    /**
     * The mediaMetadata
     * Meta information extracted from the WSDL
     * - choice: mediaCollection | mediaMetadata
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \StructType\MediaMetadata
     */
    public $mediaMetadata;
    /**
     * Constructor method for mediaList
     * @uses MediaList::setIndex()
     * @uses MediaList::setCount()
     * @uses MediaList::setTotal()
     * @uses MediaList::setPositionInformation()
     * @uses MediaList::setMediaCollection()
     * @uses MediaList::setMediaMetadata()
     * @param int $index
     * @param int $count
     * @param int $total
     * @param \StructType\PositionInformation $positionInformation
     * @param \StructType\MediaCollection $mediaCollection
     * @param \StructType\MediaMetadata $mediaMetadata
     */
    public function __construct($index = null, $count = null, $total = null, \StructType\PositionInformation $positionInformation = null, \StructType\MediaCollection $mediaCollection = null, \StructType\MediaMetadata $mediaMetadata = null)
    {
        $this
            ->setIndex($index)
            ->setCount($count)
            ->setTotal($total)
            ->setPositionInformation($positionInformation)
            ->setMediaCollection($mediaCollection)
            ->setMediaMetadata($mediaMetadata);
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\MediaList
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\MediaList
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\MediaList
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get positionInformation value
     * @return \StructType\PositionInformation|null
     */
    public function getPositionInformation()
    {
        return $this->positionInformation;
    }
    /**
     * Set positionInformation value
     * @param \StructType\PositionInformation $positionInformation
     * @return \StructType\MediaList
     */
    public function setPositionInformation(\StructType\PositionInformation $positionInformation = null)
    {
        $this->positionInformation = $positionInformation;
        return $this;
    }
    /**
     * Get mediaCollection value
     * @return \StructType\MediaCollection|null
     */
    public function getMediaCollection()
    {
        return isset($this->mediaCollection) ? $this->mediaCollection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMediaCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaCollection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMediaCollectionForChoiceConstraintsFromSetMediaCollection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'mediaMetadata',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property mediaCollection can\'t be set as the property %s is already set. Only one property must be set among these properties: mediaCollection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set mediaCollection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaCollection $mediaCollection
     * @return \StructType\MediaList
     */
    public function setMediaCollection(\StructType\MediaCollection $mediaCollection = null)
    {
        // validation for constraint: choice(mediaCollection, mediaMetadata)
        if ('' !== ($mediaCollectionChoiceErrorMessage = self::validateMediaCollectionForChoiceConstraintsFromSetMediaCollection($mediaCollection))) {
            throw new \InvalidArgumentException($mediaCollectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($mediaCollection) || (is_array($mediaCollection) && empty($mediaCollection))) {
            unset($this->mediaCollection);
        } else {
            $this->mediaCollection = $mediaCollection;
        }
        return $this;
    }
    /**
     * Get mediaMetadata value
     * @return \StructType\MediaMetadata|null
     */
    public function getMediaMetadata()
    {
        return isset($this->mediaMetadata) ? $this->mediaMetadata : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMediaMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaMetadata method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'mediaCollection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property mediaMetadata can\'t be set as the property %s is already set. Only one property must be set among these properties: mediaMetadata, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set mediaMetadata value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaMetadata $mediaMetadata
     * @return \StructType\MediaList
     */
    public function setMediaMetadata(\StructType\MediaMetadata $mediaMetadata = null)
    {
        // validation for constraint: choice(mediaCollection, mediaMetadata)
        if ('' !== ($mediaMetadataChoiceErrorMessage = self::validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($mediaMetadata))) {
            throw new \InvalidArgumentException($mediaMetadataChoiceErrorMessage, __LINE__);
        }
        if (is_null($mediaMetadata) || (is_array($mediaMetadata) && empty($mediaMetadata))) {
            unset($this->mediaMetadata);
        } else {
            $this->mediaMetadata = $mediaMetadata;
        }
        return $this;
    }
}
