<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mediaCollection StructType
 * @subpackage Structs
 */
class MediaCollection extends AbstractMedia
{
    /**
     * The artist
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $artist;
    /**
     * The artistId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $artistId;
    /**
     * The authorId
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorId;
    /**
     * The author
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $author;
    /**
     * The narratorId
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $narratorId;
    /**
     * The narrator
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $narrator;
    /**
     * The producerId
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $producerId;
    /**
     * The producer
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $producer;
    /**
     * The podcastId
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $podcastId;
    /**
     * The podcast
     * Meta information extracted from the WSDL
     * - choice: artist | artistId | authorId | author | narratorId | narrator | producerId | producer | podcastId | podcast
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $podcast;
    /**
     * The canScroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canScroll;
    /**
     * The canPlay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canPlay;
    /**
     * The canEnumerate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canEnumerate;
    /**
     * The canAddToFavorites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canAddToFavorites;
    /**
     * The containsFavorite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $containsFavorite;
    /**
     * The canSkip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canSkip;
    /**
     * The albumArtURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlbumArtUrl
     */
    public $albumArtURI;
    /**
     * The canResume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canResume;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * The readOnly
     * Meta information extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $readOnly;
    /**
     * The canReorderItems
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $canReorderItems;
    /**
     * The canDeleteItems
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $canDeleteItems;
    /**
     * The renameable
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $renameable;
    /**
     * The userContent
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $userContent;
    /**
     * Constructor method for mediaCollection
     * @uses MediaCollection::setArtist()
     * @uses MediaCollection::setArtistId()
     * @uses MediaCollection::setAuthorId()
     * @uses MediaCollection::setAuthor()
     * @uses MediaCollection::setNarratorId()
     * @uses MediaCollection::setNarrator()
     * @uses MediaCollection::setProducerId()
     * @uses MediaCollection::setProducer()
     * @uses MediaCollection::setPodcastId()
     * @uses MediaCollection::setPodcast()
     * @uses MediaCollection::setCanScroll()
     * @uses MediaCollection::setCanPlay()
     * @uses MediaCollection::setCanEnumerate()
     * @uses MediaCollection::setCanAddToFavorites()
     * @uses MediaCollection::setContainsFavorite()
     * @uses MediaCollection::setCanSkip()
     * @uses MediaCollection::setAlbumArtURI()
     * @uses MediaCollection::setCanResume()
     * @uses MediaCollection::setTotal()
     * @uses MediaCollection::setReadOnly()
     * @uses MediaCollection::setCanReorderItems()
     * @uses MediaCollection::setCanDeleteItems()
     * @uses MediaCollection::setRenameable()
     * @uses MediaCollection::setUserContent()
     * @param string $artist
     * @param string $artistId
     * @param string $authorId
     * @param string $author
     * @param string $narratorId
     * @param string $narrator
     * @param string $producerId
     * @param string $producer
     * @param string $podcastId
     * @param string $podcast
     * @param bool $canScroll
     * @param bool $canPlay
     * @param bool $canEnumerate
     * @param bool $canAddToFavorites
     * @param bool $containsFavorite
     * @param bool $canSkip
     * @param \StructType\AlbumArtUrl $albumArtURI
     * @param bool $canResume
     * @param int $total
     * @param bool $readOnly
     * @param bool $canReorderItems
     * @param bool $canDeleteItems
     * @param bool $renameable
     * @param bool $userContent
     */
    public function __construct($artist = null, $artistId = null, $authorId = null, $author = null, $narratorId = null, $narrator = null, $producerId = null, $producer = null, $podcastId = null, $podcast = null, $canScroll = null, $canPlay = null, $canEnumerate = null, $canAddToFavorites = null, $containsFavorite = null, $canSkip = null, \StructType\AlbumArtUrl $albumArtURI = null, $canResume = null, $total = null, $readOnly = true, $canReorderItems = false, $canDeleteItems = false, $renameable = false, $userContent = false)
    {
        $this
            ->setArtist($artist)
            ->setArtistId($artistId)
            ->setAuthorId($authorId)
            ->setAuthor($author)
            ->setNarratorId($narratorId)
            ->setNarrator($narrator)
            ->setProducerId($producerId)
            ->setProducer($producer)
            ->setPodcastId($podcastId)
            ->setPodcast($podcast)
            ->setCanScroll($canScroll)
            ->setCanPlay($canPlay)
            ->setCanEnumerate($canEnumerate)
            ->setCanAddToFavorites($canAddToFavorites)
            ->setContainsFavorite($containsFavorite)
            ->setCanSkip($canSkip)
            ->setAlbumArtURI($albumArtURI)
            ->setCanResume($canResume)
            ->setTotal($total)
            ->setReadOnly($readOnly)
            ->setCanReorderItems($canReorderItems)
            ->setCanDeleteItems($canDeleteItems)
            ->setRenameable($renameable)
            ->setUserContent($userContent);
    }
    /**
     * Get artist value
     * @return string|null
     */
    public function getArtist()
    {
        return isset($this->artist) ? $this->artist : null;
    }
    /**
     * This method is responsible for validating the value passed to the setArtist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtist method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateArtistForChoiceConstraintsFromSetArtist($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property artist can\'t be set as the property %s is already set. Only one property must be set among these properties: artist, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set artist value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $artist
     * @return \StructType\MediaCollection
     */
    public function setArtist($artist = null)
    {
        // validation for constraint: string
        if (!is_null($artist) && !is_string($artist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artist, true), gettype($artist)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($artistChoiceErrorMessage = self::validateArtistForChoiceConstraintsFromSetArtist($artist))) {
            throw new \InvalidArgumentException($artistChoiceErrorMessage, __LINE__);
        }
        if (is_null($artist) || (is_array($artist) && empty($artist))) {
            unset($this->artist);
        } else {
            $this->artist = $artist;
        }
        return $this;
    }
    /**
     * Get artistId value
     * @return string|null
     */
    public function getArtistId()
    {
        return isset($this->artistId) ? $this->artistId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setArtistId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtistId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateArtistIdForChoiceConstraintsFromSetArtistId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property artistId can\'t be set as the property %s is already set. Only one property must be set among these properties: artistId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set artistId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $artistId
     * @return \StructType\MediaCollection
     */
    public function setArtistId($artistId = null)
    {
        // validation for constraint: string
        if (!is_null($artistId) && !is_string($artistId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artistId, true), gettype($artistId)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($artistIdChoiceErrorMessage = self::validateArtistIdForChoiceConstraintsFromSetArtistId($artistId))) {
            throw new \InvalidArgumentException($artistIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($artistId) && mb_strlen($artistId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($artistId)), __LINE__);
        }
        if (is_null($artistId) || (is_array($artistId) && empty($artistId))) {
            unset($this->artistId);
        } else {
            $this->artistId = $artistId;
        }
        return $this;
    }
    /**
     * Get authorId value
     * @return string|null
     */
    public function getAuthorId()
    {
        return isset($this->authorId) ? $this->authorId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthorId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorIdForChoiceConstraintsFromSetAuthorId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property authorId can\'t be set as the property %s is already set. Only one property must be set among these properties: authorId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set authorId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $authorId
     * @return \StructType\MediaCollection
     */
    public function setAuthorId($authorId = null)
    {
        // validation for constraint: string
        if (!is_null($authorId) && !is_string($authorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorId, true), gettype($authorId)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($authorIdChoiceErrorMessage = self::validateAuthorIdForChoiceConstraintsFromSetAuthorId($authorId))) {
            throw new \InvalidArgumentException($authorIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($authorId) || (is_array($authorId) && empty($authorId))) {
            unset($this->authorId);
        } else {
            $this->authorId = $authorId;
        }
        return $this;
    }
    /**
     * Get author value
     * @return string|null
     */
    public function getAuthor()
    {
        return isset($this->author) ? $this->author : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthor method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorForChoiceConstraintsFromSetAuthor($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property author can\'t be set as the property %s is already set. Only one property must be set among these properties: author, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set author value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $author
     * @return \StructType\MediaCollection
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($authorChoiceErrorMessage = self::validateAuthorForChoiceConstraintsFromSetAuthor($author))) {
            throw new \InvalidArgumentException($authorChoiceErrorMessage, __LINE__);
        }
        if (is_null($author) || (is_array($author) && empty($author))) {
            unset($this->author);
        } else {
            $this->author = $author;
        }
        return $this;
    }
    /**
     * Get narratorId value
     * @return string|null
     */
    public function getNarratorId()
    {
        return isset($this->narratorId) ? $this->narratorId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNarratorId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNarratorId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNarratorIdForChoiceConstraintsFromSetNarratorId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property narratorId can\'t be set as the property %s is already set. Only one property must be set among these properties: narratorId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set narratorId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $narratorId
     * @return \StructType\MediaCollection
     */
    public function setNarratorId($narratorId = null)
    {
        // validation for constraint: string
        if (!is_null($narratorId) && !is_string($narratorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narratorId, true), gettype($narratorId)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($narratorIdChoiceErrorMessage = self::validateNarratorIdForChoiceConstraintsFromSetNarratorId($narratorId))) {
            throw new \InvalidArgumentException($narratorIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($narratorId) || (is_array($narratorId) && empty($narratorId))) {
            unset($this->narratorId);
        } else {
            $this->narratorId = $narratorId;
        }
        return $this;
    }
    /**
     * Get narrator value
     * @return string|null
     */
    public function getNarrator()
    {
        return isset($this->narrator) ? $this->narrator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNarrator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNarrator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNarratorForChoiceConstraintsFromSetNarrator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'producerId',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property narrator can\'t be set as the property %s is already set. Only one property must be set among these properties: narrator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set narrator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $narrator
     * @return \StructType\MediaCollection
     */
    public function setNarrator($narrator = null)
    {
        // validation for constraint: string
        if (!is_null($narrator) && !is_string($narrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narrator, true), gettype($narrator)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($narratorChoiceErrorMessage = self::validateNarratorForChoiceConstraintsFromSetNarrator($narrator))) {
            throw new \InvalidArgumentException($narratorChoiceErrorMessage, __LINE__);
        }
        if (is_null($narrator) || (is_array($narrator) && empty($narrator))) {
            unset($this->narrator);
        } else {
            $this->narrator = $narrator;
        }
        return $this;
    }
    /**
     * Get producerId value
     * @return string|null
     */
    public function getProducerId()
    {
        return isset($this->producerId) ? $this->producerId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProducerId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducerId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProducerIdForChoiceConstraintsFromSetProducerId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producer',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property producerId can\'t be set as the property %s is already set. Only one property must be set among these properties: producerId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set producerId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $producerId
     * @return \StructType\MediaCollection
     */
    public function setProducerId($producerId = null)
    {
        // validation for constraint: string
        if (!is_null($producerId) && !is_string($producerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producerId, true), gettype($producerId)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($producerIdChoiceErrorMessage = self::validateProducerIdForChoiceConstraintsFromSetProducerId($producerId))) {
            throw new \InvalidArgumentException($producerIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($producerId) || (is_array($producerId) && empty($producerId))) {
            unset($this->producerId);
        } else {
            $this->producerId = $producerId;
        }
        return $this;
    }
    /**
     * Get producer value
     * @return string|null
     */
    public function getProducer()
    {
        return isset($this->producer) ? $this->producer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProducer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProducerForChoiceConstraintsFromSetProducer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'podcastId',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property producer can\'t be set as the property %s is already set. Only one property must be set among these properties: producer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set producer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $producer
     * @return \StructType\MediaCollection
     */
    public function setProducer($producer = null)
    {
        // validation for constraint: string
        if (!is_null($producer) && !is_string($producer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producer, true), gettype($producer)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($producerChoiceErrorMessage = self::validateProducerForChoiceConstraintsFromSetProducer($producer))) {
            throw new \InvalidArgumentException($producerChoiceErrorMessage, __LINE__);
        }
        if (is_null($producer) || (is_array($producer) && empty($producer))) {
            unset($this->producer);
        } else {
            $this->producer = $producer;
        }
        return $this;
    }
    /**
     * Get podcastId value
     * @return string|null
     */
    public function getPodcastId()
    {
        return isset($this->podcastId) ? $this->podcastId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPodcastId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPodcastId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePodcastIdForChoiceConstraintsFromSetPodcastId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcast',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property podcastId can\'t be set as the property %s is already set. Only one property must be set among these properties: podcastId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set podcastId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $podcastId
     * @return \StructType\MediaCollection
     */
    public function setPodcastId($podcastId = null)
    {
        // validation for constraint: string
        if (!is_null($podcastId) && !is_string($podcastId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podcastId, true), gettype($podcastId)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($podcastIdChoiceErrorMessage = self::validatePodcastIdForChoiceConstraintsFromSetPodcastId($podcastId))) {
            throw new \InvalidArgumentException($podcastIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($podcastId) || (is_array($podcastId) && empty($podcastId))) {
            unset($this->podcastId);
        } else {
            $this->podcastId = $podcastId;
        }
        return $this;
    }
    /**
     * Get podcast value
     * @return string|null
     */
    public function getPodcast()
    {
        return isset($this->podcast) ? $this->podcast : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPodcast method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPodcast method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePodcastForChoiceConstraintsFromSetPodcast($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'artist',
            'artistId',
            'authorId',
            'author',
            'narratorId',
            'narrator',
            'producerId',
            'producer',
            'podcastId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property podcast can\'t be set as the property %s is already set. Only one property must be set among these properties: podcast, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set podcast value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $podcast
     * @return \StructType\MediaCollection
     */
    public function setPodcast($podcast = null)
    {
        // validation for constraint: string
        if (!is_null($podcast) && !is_string($podcast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podcast, true), gettype($podcast)), __LINE__);
        }
        // validation for constraint: choice(artist, artistId, authorId, author, narratorId, narrator, producerId, producer, podcastId, podcast)
        if ('' !== ($podcastChoiceErrorMessage = self::validatePodcastForChoiceConstraintsFromSetPodcast($podcast))) {
            throw new \InvalidArgumentException($podcastChoiceErrorMessage, __LINE__);
        }
        if (is_null($podcast) || (is_array($podcast) && empty($podcast))) {
            unset($this->podcast);
        } else {
            $this->podcast = $podcast;
        }
        return $this;
    }
    /**
     * Get canScroll value
     * @return bool|null
     */
    public function getCanScroll()
    {
        return $this->canScroll;
    }
    /**
     * Set canScroll value
     * @param bool $canScroll
     * @return \StructType\MediaCollection
     */
    public function setCanScroll($canScroll = null)
    {
        // validation for constraint: boolean
        if (!is_null($canScroll) && !is_bool($canScroll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canScroll, true), gettype($canScroll)), __LINE__);
        }
        $this->canScroll = $canScroll;
        return $this;
    }
    /**
     * Get canPlay value
     * @return bool|null
     */
    public function getCanPlay()
    {
        return $this->canPlay;
    }
    /**
     * Set canPlay value
     * @param bool $canPlay
     * @return \StructType\MediaCollection
     */
    public function setCanPlay($canPlay = null)
    {
        // validation for constraint: boolean
        if (!is_null($canPlay) && !is_bool($canPlay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canPlay, true), gettype($canPlay)), __LINE__);
        }
        $this->canPlay = $canPlay;
        return $this;
    }
    /**
     * Get canEnumerate value
     * @return bool|null
     */
    public function getCanEnumerate()
    {
        return $this->canEnumerate;
    }
    /**
     * Set canEnumerate value
     * @param bool $canEnumerate
     * @return \StructType\MediaCollection
     */
    public function setCanEnumerate($canEnumerate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canEnumerate) && !is_bool($canEnumerate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canEnumerate, true), gettype($canEnumerate)), __LINE__);
        }
        $this->canEnumerate = $canEnumerate;
        return $this;
    }
    /**
     * Get canAddToFavorites value
     * @return bool|null
     */
    public function getCanAddToFavorites()
    {
        return $this->canAddToFavorites;
    }
    /**
     * Set canAddToFavorites value
     * @param bool $canAddToFavorites
     * @return \StructType\MediaCollection
     */
    public function setCanAddToFavorites($canAddToFavorites = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAddToFavorites) && !is_bool($canAddToFavorites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAddToFavorites, true), gettype($canAddToFavorites)), __LINE__);
        }
        $this->canAddToFavorites = $canAddToFavorites;
        return $this;
    }
    /**
     * Get containsFavorite value
     * @return bool|null
     */
    public function getContainsFavorite()
    {
        return $this->containsFavorite;
    }
    /**
     * Set containsFavorite value
     * @param bool $containsFavorite
     * @return \StructType\MediaCollection
     */
    public function setContainsFavorite($containsFavorite = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsFavorite) && !is_bool($containsFavorite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsFavorite, true), gettype($containsFavorite)), __LINE__);
        }
        $this->containsFavorite = $containsFavorite;
        return $this;
    }
    /**
     * Get canSkip value
     * @return bool|null
     */
    public function getCanSkip()
    {
        return $this->canSkip;
    }
    /**
     * Set canSkip value
     * @param bool $canSkip
     * @return \StructType\MediaCollection
     */
    public function setCanSkip($canSkip = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSkip) && !is_bool($canSkip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSkip, true), gettype($canSkip)), __LINE__);
        }
        $this->canSkip = $canSkip;
        return $this;
    }
    /**
     * Get albumArtURI value
     * @return \StructType\AlbumArtUrl|null
     */
    public function getAlbumArtURI()
    {
        return $this->albumArtURI;
    }
    /**
     * Set albumArtURI value
     * @param \StructType\AlbumArtUrl $albumArtURI
     * @return \StructType\MediaCollection
     */
    public function setAlbumArtURI(\StructType\AlbumArtUrl $albumArtURI = null)
    {
        $this->albumArtURI = $albumArtURI;
        return $this;
    }
    /**
     * Get canResume value
     * @return bool|null
     */
    public function getCanResume()
    {
        return $this->canResume;
    }
    /**
     * Set canResume value
     * @param bool $canResume
     * @return \StructType\MediaCollection
     */
    public function setCanResume($canResume = null)
    {
        // validation for constraint: boolean
        if (!is_null($canResume) && !is_bool($canResume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canResume, true), gettype($canResume)), __LINE__);
        }
        $this->canResume = $canResume;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\MediaCollection
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get readOnly value
     * @return bool|null
     */
    public function getReadOnly()
    {
        return $this->readOnly;
    }
    /**
     * Set readOnly value
     * @param bool $readOnly
     * @return \StructType\MediaCollection
     */
    public function setReadOnly($readOnly = true)
    {
        // validation for constraint: boolean
        if (!is_null($readOnly) && !is_bool($readOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($readOnly, true), gettype($readOnly)), __LINE__);
        }
        $this->readOnly = $readOnly;
        return $this;
    }
    /**
     * Get canReorderItems value
     * @return bool|null
     */
    public function getCanReorderItems()
    {
        return $this->canReorderItems;
    }
    /**
     * Set canReorderItems value
     * @param bool $canReorderItems
     * @return \StructType\MediaCollection
     */
    public function setCanReorderItems($canReorderItems = false)
    {
        // validation for constraint: boolean
        if (!is_null($canReorderItems) && !is_bool($canReorderItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canReorderItems, true), gettype($canReorderItems)), __LINE__);
        }
        $this->canReorderItems = $canReorderItems;
        return $this;
    }
    /**
     * Get canDeleteItems value
     * @return bool|null
     */
    public function getCanDeleteItems()
    {
        return $this->canDeleteItems;
    }
    /**
     * Set canDeleteItems value
     * @param bool $canDeleteItems
     * @return \StructType\MediaCollection
     */
    public function setCanDeleteItems($canDeleteItems = false)
    {
        // validation for constraint: boolean
        if (!is_null($canDeleteItems) && !is_bool($canDeleteItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canDeleteItems, true), gettype($canDeleteItems)), __LINE__);
        }
        $this->canDeleteItems = $canDeleteItems;
        return $this;
    }
    /**
     * Get renameable value
     * @return bool|null
     */
    public function getRenameable()
    {
        return $this->renameable;
    }
    /**
     * Set renameable value
     * @param bool $renameable
     * @return \StructType\MediaCollection
     */
    public function setRenameable($renameable = false)
    {
        // validation for constraint: boolean
        if (!is_null($renameable) && !is_bool($renameable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($renameable, true), gettype($renameable)), __LINE__);
        }
        $this->renameable = $renameable;
        return $this;
    }
    /**
     * Get userContent value
     * @return bool|null
     */
    public function getUserContent()
    {
        return $this->userContent;
    }
    /**
     * Set userContent value
     * @param bool $userContent
     * @return \StructType\MediaCollection
     */
    public function setUserContent($userContent = false)
    {
        // validation for constraint: boolean
        if (!is_null($userContent) && !is_bool($userContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userContent, true), gettype($userContent)), __LINE__);
        }
        $this->userContent = $userContent;
        return $this;
    }
}
