<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loginToken StructType
 * @subpackage Structs
 */
class LoginToken extends AbstractStructBase
{
    /**
     * The token
     * @var string
     */
    public $token;
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * The householdId
     * @var string
     */
    public $householdId;
    /**
     * Constructor method for loginToken
     * @uses LoginToken::setToken()
     * @uses LoginToken::setKey()
     * @uses LoginToken::setHouseholdId()
     * @param string $token
     * @param string $key
     * @param string $householdId
     */
    public function __construct($token = null, $key = null, $householdId = null)
    {
        $this
            ->setToken($token)
            ->setKey($key)
            ->setHouseholdId($householdId);
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\LoginToken
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\LoginToken
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get householdId value
     * @return string|null
     */
    public function getHouseholdId()
    {
        return $this->householdId;
    }
    /**
     * Set householdId value
     * @param string $householdId
     * @return \StructType\LoginToken
     */
    public function setHouseholdId($householdId = null)
    {
        // validation for constraint: string
        if (!is_null($householdId) && !is_string($householdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($householdId, true), gettype($householdId)), __LINE__);
        }
        $this->householdId = $householdId;
        return $this;
    }
}
