<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for httpHeader StructType
 * @subpackage Structs
 */
class HttpHeader extends AbstractStructBase
{
    /**
     * The header
     * @var string
     */
    public $header;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for httpHeader
     * @uses HttpHeader::setHeader()
     * @uses HttpHeader::setValue()
     * @param string $header
     * @param string $value
     */
    public function __construct($header = null, $value = null)
    {
        $this
            ->setHeader($header)
            ->setValue($value);
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \StructType\HttpHeader
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\HttpHeader
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
