<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSessionIdResponse StructType
 * @subpackage Structs
 */
class GetSessionIdResponse extends AbstractStructBase
{
    /**
     * The getSessionIdResult
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $getSessionIdResult;
    /**
     * Constructor method for getSessionIdResponse
     * @uses GetSessionIdResponse::setGetSessionIdResult()
     * @param string $getSessionIdResult
     */
    public function __construct($getSessionIdResult = null)
    {
        $this
            ->setGetSessionIdResult($getSessionIdResult);
    }
    /**
     * Get getSessionIdResult value
     * @return string|null
     */
    public function getGetSessionIdResult()
    {
        return $this->getSessionIdResult;
    }
    /**
     * Set getSessionIdResult value
     * @param string $getSessionIdResult
     * @return \StructType\GetSessionIdResponse
     */
    public function setGetSessionIdResult($getSessionIdResult = null)
    {
        // validation for constraint: string
        if (!is_null($getSessionIdResult) && !is_string($getSessionIdResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($getSessionIdResult, true), gettype($getSessionIdResult)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($getSessionIdResult) && mb_strlen($getSessionIdResult) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($getSessionIdResult)), __LINE__);
        }
        $this->getSessionIdResult = $getSessionIdResult;
        return $this;
    }
}
