<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMetadata StructType
 * @subpackage Structs
 */
class GetMetadata extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The index
     * @var int
     */
    public $index;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The recursive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $recursive;
    /**
     * Constructor method for getMetadata
     * @uses GetMetadata::setId()
     * @uses GetMetadata::setIndex()
     * @uses GetMetadata::setCount()
     * @uses GetMetadata::setRecursive()
     * @param string $id
     * @param int $index
     * @param int $count
     * @param bool $recursive
     */
    public function __construct($id = null, $index = null, $count = null, $recursive = null)
    {
        $this
            ->setId($id)
            ->setIndex($index)
            ->setCount($count)
            ->setRecursive($recursive);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetMetadata
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\GetMetadata
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetMetadata
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get recursive value
     * @return bool|null
     */
    public function getRecursive()
    {
        return $this->recursive;
    }
    /**
     * Set recursive value
     * @param bool $recursive
     * @return \StructType\GetMetadata
     */
    public function setRecursive($recursive = null)
    {
        // validation for constraint: boolean
        if (!is_null($recursive) && !is_bool($recursive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recursive, true), gettype($recursive)), __LINE__);
        }
        $this->recursive = $recursive;
        return $this;
    }
}
