<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMediaURIResponse StructType
 * @subpackage Structs
 */
class GetMediaURIResponse extends AbstractStructBase
{
    /**
     * The getMediaURIResult
     * @var string
     */
    public $getMediaURIResult;
    /**
     * The deviceSessionToken
     * Meta information extracted from the WSDL
     * - documentation: It is a token that is specific to a device to allow that device to stream. If a deviceSessionToken was returned in a previous call, this is provided here. There may be some tracks that do not include one in the mediaUriResponse; this
     * will not cause Sonos to remove the previous deviceSessionToken. Sonos will send this element until a new one is returned, always. This element can be used to avoid having to re-validate the cert by encoding that information. It can provide a lower
     * cost short cut for encoding session keys.
     * - base: xs:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSessionToken;
    /**
     * The deviceSessionKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionContext
     */
    public $deviceSessionKey;
    /**
     * The contentKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionContext
     */
    public $contentKey;
    /**
     * The httpHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HttpHeaders
     */
    public $httpHeaders;
    /**
     * The uriTimeout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $uriTimeout;
    /**
     * The positionInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionInformation
     */
    public $positionInformation;
    /**
     * The privateDataFieldName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $privateDataFieldName;
    /**
     * Constructor method for getMediaURIResponse
     * @uses GetMediaURIResponse::setGetMediaURIResult()
     * @uses GetMediaURIResponse::setDeviceSessionToken()
     * @uses GetMediaURIResponse::setDeviceSessionKey()
     * @uses GetMediaURIResponse::setContentKey()
     * @uses GetMediaURIResponse::setHttpHeaders()
     * @uses GetMediaURIResponse::setUriTimeout()
     * @uses GetMediaURIResponse::setPositionInformation()
     * @uses GetMediaURIResponse::setPrivateDataFieldName()
     * @param string $getMediaURIResult
     * @param string $deviceSessionToken
     * @param \StructType\EncryptionContext $deviceSessionKey
     * @param \StructType\EncryptionContext $contentKey
     * @param \StructType\HttpHeaders $httpHeaders
     * @param int $uriTimeout
     * @param \StructType\PositionInformation $positionInformation
     * @param string $privateDataFieldName
     */
    public function __construct($getMediaURIResult = null, $deviceSessionToken = null, \StructType\EncryptionContext $deviceSessionKey = null, \StructType\EncryptionContext $contentKey = null, \StructType\HttpHeaders $httpHeaders = null, $uriTimeout = null, \StructType\PositionInformation $positionInformation = null, $privateDataFieldName = null)
    {
        $this
            ->setGetMediaURIResult($getMediaURIResult)
            ->setDeviceSessionToken($deviceSessionToken)
            ->setDeviceSessionKey($deviceSessionKey)
            ->setContentKey($contentKey)
            ->setHttpHeaders($httpHeaders)
            ->setUriTimeout($uriTimeout)
            ->setPositionInformation($positionInformation)
            ->setPrivateDataFieldName($privateDataFieldName);
    }
    /**
     * Get getMediaURIResult value
     * @return string|null
     */
    public function getGetMediaURIResult()
    {
        return $this->getMediaURIResult;
    }
    /**
     * Set getMediaURIResult value
     * @param string $getMediaURIResult
     * @return \StructType\GetMediaURIResponse
     */
    public function setGetMediaURIResult($getMediaURIResult = null)
    {
        // validation for constraint: string
        if (!is_null($getMediaURIResult) && !is_string($getMediaURIResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($getMediaURIResult, true), gettype($getMediaURIResult)), __LINE__);
        }
        $this->getMediaURIResult = $getMediaURIResult;
        return $this;
    }
    /**
     * Get deviceSessionToken value
     * @return string|null
     */
    public function getDeviceSessionToken()
    {
        return $this->deviceSessionToken;
    }
    /**
     * Set deviceSessionToken value
     * @param string $deviceSessionToken
     * @return \StructType\GetMediaURIResponse
     */
    public function setDeviceSessionToken($deviceSessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSessionToken) && !is_string($deviceSessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSessionToken, true), gettype($deviceSessionToken)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($deviceSessionToken) && mb_strlen($deviceSessionToken) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($deviceSessionToken)), __LINE__);
        }
        $this->deviceSessionToken = $deviceSessionToken;
        return $this;
    }
    /**
     * Get deviceSessionKey value
     * @return \StructType\EncryptionContext|null
     */
    public function getDeviceSessionKey()
    {
        return $this->deviceSessionKey;
    }
    /**
     * Set deviceSessionKey value
     * @param \StructType\EncryptionContext $deviceSessionKey
     * @return \StructType\GetMediaURIResponse
     */
    public function setDeviceSessionKey(\StructType\EncryptionContext $deviceSessionKey = null)
    {
        $this->deviceSessionKey = $deviceSessionKey;
        return $this;
    }
    /**
     * Get contentKey value
     * @return \StructType\EncryptionContext|null
     */
    public function getContentKey()
    {
        return $this->contentKey;
    }
    /**
     * Set contentKey value
     * @param \StructType\EncryptionContext $contentKey
     * @return \StructType\GetMediaURIResponse
     */
    public function setContentKey(\StructType\EncryptionContext $contentKey = null)
    {
        $this->contentKey = $contentKey;
        return $this;
    }
    /**
     * Get httpHeaders value
     * @return \StructType\HttpHeaders|null
     */
    public function getHttpHeaders()
    {
        return $this->httpHeaders;
    }
    /**
     * Set httpHeaders value
     * @param \StructType\HttpHeaders $httpHeaders
     * @return \StructType\GetMediaURIResponse
     */
    public function setHttpHeaders(\StructType\HttpHeaders $httpHeaders = null)
    {
        $this->httpHeaders = $httpHeaders;
        return $this;
    }
    /**
     * Get uriTimeout value
     * @return int|null
     */
    public function getUriTimeout()
    {
        return $this->uriTimeout;
    }
    /**
     * Set uriTimeout value
     * @param int $uriTimeout
     * @return \StructType\GetMediaURIResponse
     */
    public function setUriTimeout($uriTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($uriTimeout) && !(is_int($uriTimeout) || ctype_digit($uriTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uriTimeout, true), gettype($uriTimeout)), __LINE__);
        }
        $this->uriTimeout = $uriTimeout;
        return $this;
    }
    /**
     * Get positionInformation value
     * @return \StructType\PositionInformation|null
     */
    public function getPositionInformation()
    {
        return $this->positionInformation;
    }
    /**
     * Set positionInformation value
     * @param \StructType\PositionInformation $positionInformation
     * @return \StructType\GetMediaURIResponse
     */
    public function setPositionInformation(\StructType\PositionInformation $positionInformation = null)
    {
        $this->positionInformation = $positionInformation;
        return $this;
    }
    /**
     * Get privateDataFieldName value
     * @return string|null
     */
    public function getPrivateDataFieldName()
    {
        return $this->privateDataFieldName;
    }
    /**
     * Set privateDataFieldName value
     * @param string $privateDataFieldName
     * @return \StructType\GetMediaURIResponse
     */
    public function setPrivateDataFieldName($privateDataFieldName = null)
    {
        // validation for constraint: string
        if (!is_null($privateDataFieldName) && !is_string($privateDataFieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privateDataFieldName, true), gettype($privateDataFieldName)), __LINE__);
        }
        $this->privateDataFieldName = $privateDataFieldName;
        return $this;
    }
}
