<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMediaURI StructType
 * @subpackage Structs
 */
class GetMediaURI extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $action;
    /**
     * The secondsSinceExplicit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $secondsSinceExplicit;
    /**
     * The deviceSessionToken
     * Meta information extracted from the WSDL
     * - documentation: It is a token that is specific to a device to allow that device to stream. If a deviceSessionToken was returned in a previous call, this is provided here. There may be some tracks that do not include one in the mediaUriResponse; this
     * will not cause Sonos to remove the previous deviceSessionToken. Sonos will send this element until a new one is returned, always. This element can be used to avoid having to re-validate the cert by encoding that information. It can provide a lower
     * cost short cut for encoding session keys.
     * - base: xs:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSessionToken;
    /**
     * Constructor method for getMediaURI
     * @uses GetMediaURI::setId()
     * @uses GetMediaURI::setAction()
     * @uses GetMediaURI::setSecondsSinceExplicit()
     * @uses GetMediaURI::setDeviceSessionToken()
     * @param string $id
     * @param string $action
     * @param int $secondsSinceExplicit
     * @param string $deviceSessionToken
     */
    public function __construct($id = null, $action = null, $secondsSinceExplicit = null, $deviceSessionToken = null)
    {
        $this
            ->setId($id)
            ->setAction($action)
            ->setSecondsSinceExplicit($secondsSinceExplicit)
            ->setDeviceSessionToken($deviceSessionToken);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetMediaURI
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\MediaUriAction::valueIsValid()
     * @uses \EnumType\MediaUriAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\GetMediaURI
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MediaUriAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MediaUriAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\MediaUriAction::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get secondsSinceExplicit value
     * @return int|null
     */
    public function getSecondsSinceExplicit()
    {
        return $this->secondsSinceExplicit;
    }
    /**
     * Set secondsSinceExplicit value
     * @param int $secondsSinceExplicit
     * @return \StructType\GetMediaURI
     */
    public function setSecondsSinceExplicit($secondsSinceExplicit = null)
    {
        // validation for constraint: int
        if (!is_null($secondsSinceExplicit) && !(is_int($secondsSinceExplicit) || ctype_digit($secondsSinceExplicit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secondsSinceExplicit, true), gettype($secondsSinceExplicit)), __LINE__);
        }
        $this->secondsSinceExplicit = $secondsSinceExplicit;
        return $this;
    }
    /**
     * Get deviceSessionToken value
     * @return string|null
     */
    public function getDeviceSessionToken()
    {
        return $this->deviceSessionToken;
    }
    /**
     * Set deviceSessionToken value
     * @param string $deviceSessionToken
     * @return \StructType\GetMediaURI
     */
    public function setDeviceSessionToken($deviceSessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSessionToken) && !is_string($deviceSessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSessionToken, true), gettype($deviceSessionToken)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($deviceSessionToken) && mb_strlen($deviceSessionToken) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($deviceSessionToken)), __LINE__);
        }
        $this->deviceSessionToken = $deviceSessionToken;
        return $this;
    }
}
