<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDeviceLinkCode StructType
 * @subpackage Structs
 */
class GetDeviceLinkCode extends AbstractStructBase
{
    /**
     * The householdId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $householdId;
    /**
     * Constructor method for getDeviceLinkCode
     * @uses GetDeviceLinkCode::setHouseholdId()
     * @param string $householdId
     */
    public function __construct($householdId = null)
    {
        $this
            ->setHouseholdId($householdId);
    }
    /**
     * Get householdId value
     * @return string|null
     */
    public function getHouseholdId()
    {
        return $this->householdId;
    }
    /**
     * Set householdId value
     * @param string $householdId
     * @return \StructType\GetDeviceLinkCode
     */
    public function setHouseholdId($householdId = null)
    {
        // validation for constraint: string
        if (!is_null($householdId) && !is_string($householdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($householdId, true), gettype($householdId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($householdId) && mb_strlen($householdId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($householdId)), __LINE__);
        }
        $this->householdId = $householdId;
        return $this;
    }
}
