<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getContentKey StructType
 * @subpackage Structs
 */
class GetContentKey extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The uri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uri;
    /**
     * The deviceSessionToken
     * Meta information extracted from the WSDL
     * - documentation: It is a token that is specific to a device to allow that device to stream. If a deviceSessionToken was returned in a previous call, this is provided here. There may be some tracks that do not include one in the mediaUriResponse; this
     * will not cause Sonos to remove the previous deviceSessionToken. Sonos will send this element until a new one is returned, always. This element can be used to avoid having to re-validate the cert by encoding that information. It can provide a lower
     * cost short cut for encoding session keys.
     * - base: xs:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSessionToken;
    /**
     * Constructor method for getContentKey
     * @uses GetContentKey::setId()
     * @uses GetContentKey::setUri()
     * @uses GetContentKey::setDeviceSessionToken()
     * @param string $id
     * @param string $uri
     * @param string $deviceSessionToken
     */
    public function __construct($id = null, $uri = null, $deviceSessionToken = null)
    {
        $this
            ->setId($id)
            ->setUri($uri)
            ->setDeviceSessionToken($deviceSessionToken);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetContentKey
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\GetContentKey
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get deviceSessionToken value
     * @return string|null
     */
    public function getDeviceSessionToken()
    {
        return $this->deviceSessionToken;
    }
    /**
     * Set deviceSessionToken value
     * @param string $deviceSessionToken
     * @return \StructType\GetContentKey
     */
    public function setDeviceSessionToken($deviceSessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSessionToken) && !is_string($deviceSessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSessionToken, true), gettype($deviceSessionToken)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($deviceSessionToken) && mb_strlen($deviceSessionToken) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($deviceSessionToken)), __LINE__);
        }
        $this->deviceSessionToken = $deviceSessionToken;
        return $this;
    }
}
