<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dynamicData StructType
 * @subpackage Structs
 */
class DynamicData extends AbstractStructBase
{
    /**
     * The property
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Property[]
     */
    public $property;
    /**
     * Constructor method for dynamicData
     * @uses DynamicData::setProperty()
     * @param \StructType\Property[] $property
     */
    public function __construct(array $property = array())
    {
        $this
            ->setProperty($property);
    }
    /**
     * Get property value
     * @return \StructType\Property[]|null
     */
    public function getProperty()
    {
        return $this->property;
    }
    /**
     * This method is responsible for validating the values passed to the setProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyForArrayConstraintsFromSetProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dynamicDataPropertyItem) {
            // validation for constraint: itemType
            if (!$dynamicDataPropertyItem instanceof \StructType\Property) {
                $invalidValues[] = is_object($dynamicDataPropertyItem) ? get_class($dynamicDataPropertyItem) : sprintf('%s(%s)', gettype($dynamicDataPropertyItem), var_export($dynamicDataPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The property property can only contain items of type \StructType\Property, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set property value
     * @throws \InvalidArgumentException
     * @param \StructType\Property[] $property
     * @return \StructType\DynamicData
     */
    public function setProperty(array $property = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyArrayErrorMessage = self::validatePropertyForArrayConstraintsFromSetProperty($property))) {
            throw new \InvalidArgumentException($propertyArrayErrorMessage, __LINE__);
        }
        $this->property = $property;
        return $this;
    }
    /**
     * Add item to property value
     * @throws \InvalidArgumentException
     * @param \StructType\Property $item
     * @return \StructType\DynamicData
     */
    public function addToProperty(\StructType\Property $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Property) {
            throw new \InvalidArgumentException(sprintf('The property property can only contain items of type \StructType\Property, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->property[] = $item;
        return $this;
    }
}
