<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deviceLinkCodeResult StructType
 * @subpackage Structs
 */
class DeviceLinkCodeResult extends AbstractStructBase
{
    /**
     * The regUrl
     * @var string
     */
    public $regUrl;
    /**
     * The linkCode
     * @var string
     */
    public $linkCode;
    /**
     * The showLinkCode
     * @var bool
     */
    public $showLinkCode;
    /**
     * The linkDeviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkDeviceId;
    /**
     * Constructor method for deviceLinkCodeResult
     * @uses DeviceLinkCodeResult::setRegUrl()
     * @uses DeviceLinkCodeResult::setLinkCode()
     * @uses DeviceLinkCodeResult::setShowLinkCode()
     * @uses DeviceLinkCodeResult::setLinkDeviceId()
     * @param string $regUrl
     * @param string $linkCode
     * @param bool $showLinkCode
     * @param string $linkDeviceId
     */
    public function __construct($regUrl = null, $linkCode = null, $showLinkCode = null, $linkDeviceId = null)
    {
        $this
            ->setRegUrl($regUrl)
            ->setLinkCode($linkCode)
            ->setShowLinkCode($showLinkCode)
            ->setLinkDeviceId($linkDeviceId);
    }
    /**
     * Get regUrl value
     * @return string|null
     */
    public function getRegUrl()
    {
        return $this->regUrl;
    }
    /**
     * Set regUrl value
     * @param string $regUrl
     * @return \StructType\DeviceLinkCodeResult
     */
    public function setRegUrl($regUrl = null)
    {
        // validation for constraint: string
        if (!is_null($regUrl) && !is_string($regUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regUrl, true), gettype($regUrl)), __LINE__);
        }
        $this->regUrl = $regUrl;
        return $this;
    }
    /**
     * Get linkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->linkCode;
    }
    /**
     * Set linkCode value
     * @param string $linkCode
     * @return \StructType\DeviceLinkCodeResult
     */
    public function setLinkCode($linkCode = null)
    {
        // validation for constraint: string
        if (!is_null($linkCode) && !is_string($linkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkCode, true), gettype($linkCode)), __LINE__);
        }
        $this->linkCode = $linkCode;
        return $this;
    }
    /**
     * Get showLinkCode value
     * @return bool|null
     */
    public function getShowLinkCode()
    {
        return $this->showLinkCode;
    }
    /**
     * Set showLinkCode value
     * @param bool $showLinkCode
     * @return \StructType\DeviceLinkCodeResult
     */
    public function setShowLinkCode($showLinkCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLinkCode) && !is_bool($showLinkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLinkCode, true), gettype($showLinkCode)), __LINE__);
        }
        $this->showLinkCode = $showLinkCode;
        return $this;
    }
    /**
     * Get linkDeviceId value
     * @return string|null
     */
    public function getLinkDeviceId()
    {
        return $this->linkDeviceId;
    }
    /**
     * Set linkDeviceId value
     * @param string $linkDeviceId
     * @return \StructType\DeviceLinkCodeResult
     */
    public function setLinkDeviceId($linkDeviceId = null)
    {
        // validation for constraint: string
        if (!is_null($linkDeviceId) && !is_string($linkDeviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkDeviceId, true), gettype($linkDeviceId)), __LINE__);
        }
        $this->linkDeviceId = $linkDeviceId;
        return $this;
    }
}
