<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deviceAuthTokenResult StructType
 * @subpackage Structs
 */
class DeviceAuthTokenResult extends AbstractStructBase
{
    /**
     * The authToken
     * @var string
     */
    public $authToken;
    /**
     * The privateKey
     * @var string
     */
    public $privateKey;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserInfo
     */
    public $userInfo;
    /**
     * Constructor method for deviceAuthTokenResult
     * @uses DeviceAuthTokenResult::setAuthToken()
     * @uses DeviceAuthTokenResult::setPrivateKey()
     * @uses DeviceAuthTokenResult::setUserInfo()
     * @param string $authToken
     * @param string $privateKey
     * @param \StructType\UserInfo $userInfo
     */
    public function __construct($authToken = null, $privateKey = null, \StructType\UserInfo $userInfo = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setPrivateKey($privateKey)
            ->setUserInfo($userInfo);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\DeviceAuthTokenResult
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get privateKey value
     * @return string|null
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }
    /**
     * Set privateKey value
     * @param string $privateKey
     * @return \StructType\DeviceAuthTokenResult
     */
    public function setPrivateKey($privateKey = null)
    {
        // validation for constraint: string
        if (!is_null($privateKey) && !is_string($privateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privateKey, true), gettype($privateKey)), __LINE__);
        }
        $this->privateKey = $privateKey;
        return $this;
    }
    /**
     * Get userInfo value
     * @return \StructType\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \StructType\UserInfo $userInfo
     * @return \StructType\DeviceAuthTokenResult
     */
    public function setUserInfo(\StructType\UserInfo $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
}
