<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteItem StructType
 * @subpackage Structs
 */
class DeleteItem extends AbstractStructBase
{
    /**
     * The favorite
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $favorite;
    /**
     * Constructor method for deleteItem
     * @uses DeleteItem::setFavorite()
     * @param string $favorite
     */
    public function __construct($favorite = null)
    {
        $this
            ->setFavorite($favorite);
    }
    /**
     * Get favorite value
     * @return string|null
     */
    public function getFavorite()
    {
        return $this->favorite;
    }
    /**
     * Set favorite value
     * @param string $favorite
     * @return \StructType\DeleteItem
     */
    public function setFavorite($favorite = null)
    {
        // validation for constraint: string
        if (!is_null($favorite) && !is_string($favorite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($favorite, true), gettype($favorite)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($favorite) && mb_strlen($favorite) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($favorite)), __LINE__);
        }
        $this->favorite = $favorite;
        return $this;
    }
}
