<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contentKey StructType
 * @subpackage Structs
 */
class ContentKey extends AbstractStructBase
{
    /**
     * The uri
     * @var string
     */
    public $uri;
    /**
     * The deviceSessionToken
     * Meta information extracted from the WSDL
     * - documentation: It is a token that is specific to a device to allow that device to stream. If a deviceSessionToken was returned in a previous call, this is provided here. There may be some tracks that do not include one in the mediaUriResponse; this
     * will not cause Sonos to remove the previous deviceSessionToken. Sonos will send this element until a new one is returned, always. This element can be used to avoid having to re-validate the cert by encoding that information. It can provide a lower
     * cost short cut for encoding session keys.
     * - base: xs:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSessionToken;
    /**
     * The deviceSessionKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionContext
     */
    public $deviceSessionKey;
    /**
     * The contentKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionContext
     */
    public $contentKey;
    /**
     * Constructor method for contentKey
     * @uses ContentKey::setUri()
     * @uses ContentKey::setDeviceSessionToken()
     * @uses ContentKey::setDeviceSessionKey()
     * @uses ContentKey::setContentKey()
     * @param string $uri
     * @param string $deviceSessionToken
     * @param \StructType\EncryptionContext $deviceSessionKey
     * @param \StructType\EncryptionContext $contentKey
     */
    public function __construct($uri = null, $deviceSessionToken = null, \StructType\EncryptionContext $deviceSessionKey = null, \StructType\EncryptionContext $contentKey = null)
    {
        $this
            ->setUri($uri)
            ->setDeviceSessionToken($deviceSessionToken)
            ->setDeviceSessionKey($deviceSessionKey)
            ->setContentKey($contentKey);
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\ContentKey
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get deviceSessionToken value
     * @return string|null
     */
    public function getDeviceSessionToken()
    {
        return $this->deviceSessionToken;
    }
    /**
     * Set deviceSessionToken value
     * @param string $deviceSessionToken
     * @return \StructType\ContentKey
     */
    public function setDeviceSessionToken($deviceSessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSessionToken) && !is_string($deviceSessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSessionToken, true), gettype($deviceSessionToken)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($deviceSessionToken) && mb_strlen($deviceSessionToken) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($deviceSessionToken)), __LINE__);
        }
        $this->deviceSessionToken = $deviceSessionToken;
        return $this;
    }
    /**
     * Get deviceSessionKey value
     * @return \StructType\EncryptionContext|null
     */
    public function getDeviceSessionKey()
    {
        return $this->deviceSessionKey;
    }
    /**
     * Set deviceSessionKey value
     * @param \StructType\EncryptionContext $deviceSessionKey
     * @return \StructType\ContentKey
     */
    public function setDeviceSessionKey(\StructType\EncryptionContext $deviceSessionKey = null)
    {
        $this->deviceSessionKey = $deviceSessionKey;
        return $this;
    }
    /**
     * Get contentKey value
     * @return \StructType\EncryptionContext|null
     */
    public function getContentKey()
    {
        return $this->contentKey;
    }
    /**
     * Set contentKey value
     * @param \StructType\EncryptionContext $contentKey
     * @return \StructType\ContentKey
     */
    public function setContentKey(\StructType\EncryptionContext $contentKey = null)
    {
        $this->contentKey = $contentKey;
        return $this;
    }
}
