<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appLinkResult StructType
 * @subpackage Structs
 */
class AppLinkResult extends AbstractStructBase
{
    /**
     * The authorizeAccount
     * Meta information extracted from the WSDL
     * - choice: authorizeAccount | createAccount | installAction | callToAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AppLinkInfo
     */
    public $authorizeAccount;
    /**
     * The callToAction
     * Meta information extracted from the WSDL
     * - choice: authorizeAccount | createAccount | installAction | callToAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CallToActionInfo
     */
    public $callToAction;
    /**
     * The createAccount
     * Meta information extracted from the WSDL
     * - choice: authorizeAccount | createAccount | installAction | callToAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AppLinkInfo
     */
    public $createAccount;
    /**
     * The installAction
     * Meta information extracted from the WSDL
     * - choice: authorizeAccount | createAccount | installAction | callToAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallToActionInfo
     */
    public $installAction;
    /**
     * Constructor method for appLinkResult
     * @uses AppLinkResult::setAuthorizeAccount()
     * @uses AppLinkResult::setCallToAction()
     * @uses AppLinkResult::setCreateAccount()
     * @uses AppLinkResult::setInstallAction()
     * @param \StructType\AppLinkInfo $authorizeAccount
     * @param \StructType\CallToActionInfo $callToAction
     * @param \StructType\AppLinkInfo $createAccount
     * @param \StructType\CallToActionInfo $installAction
     */
    public function __construct(\StructType\AppLinkInfo $authorizeAccount = null, \StructType\CallToActionInfo $callToAction = null, \StructType\AppLinkInfo $createAccount = null, \StructType\CallToActionInfo $installAction = null)
    {
        $this
            ->setAuthorizeAccount($authorizeAccount)
            ->setCallToAction($callToAction)
            ->setCreateAccount($createAccount)
            ->setInstallAction($installAction);
    }
    /**
     * Get authorizeAccount value
     * @return \StructType\AppLinkInfo
     */
    public function getAuthorizeAccount()
    {
        return isset($this->authorizeAccount) ? $this->authorizeAccount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthorizeAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizeAccount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorizeAccountForChoiceConstraintsFromSetAuthorizeAccount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'createAccount',
            'installAction',
            'callToAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property authorizeAccount can\'t be set as the property %s is already set. Only one property must be set among these properties: authorizeAccount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set authorizeAccount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AppLinkInfo $authorizeAccount
     * @return \StructType\AppLinkResult
     */
    public function setAuthorizeAccount(\StructType\AppLinkInfo $authorizeAccount = null)
    {
        // validation for constraint: choice(authorizeAccount, createAccount, installAction, callToAction)
        if ('' !== ($authorizeAccountChoiceErrorMessage = self::validateAuthorizeAccountForChoiceConstraintsFromSetAuthorizeAccount($authorizeAccount))) {
            throw new \InvalidArgumentException($authorizeAccountChoiceErrorMessage, __LINE__);
        }
        if (is_null($authorizeAccount) || (is_array($authorizeAccount) && empty($authorizeAccount))) {
            unset($this->authorizeAccount);
        } else {
            $this->authorizeAccount = $authorizeAccount;
        }
        return $this;
    }
    /**
     * Get callToAction value
     * @return \StructType\CallToActionInfo
     */
    public function getCallToAction()
    {
        return isset($this->callToAction) ? $this->callToAction : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCallToAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCallToAction method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCallToActionForChoiceConstraintsFromSetCallToAction($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'authorizeAccount',
            'createAccount',
            'installAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property callToAction can\'t be set as the property %s is already set. Only one property must be set among these properties: callToAction, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set callToAction value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CallToActionInfo $callToAction
     * @return \StructType\AppLinkResult
     */
    public function setCallToAction(\StructType\CallToActionInfo $callToAction = null)
    {
        // validation for constraint: choice(authorizeAccount, createAccount, installAction, callToAction)
        if ('' !== ($callToActionChoiceErrorMessage = self::validateCallToActionForChoiceConstraintsFromSetCallToAction($callToAction))) {
            throw new \InvalidArgumentException($callToActionChoiceErrorMessage, __LINE__);
        }
        if (is_null($callToAction) || (is_array($callToAction) && empty($callToAction))) {
            unset($this->callToAction);
        } else {
            $this->callToAction = $callToAction;
        }
        return $this;
    }
    /**
     * Get createAccount value
     * @return \StructType\AppLinkInfo|null
     */
    public function getCreateAccount()
    {
        return isset($this->createAccount) ? $this->createAccount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreateAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreateAccount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreateAccountForChoiceConstraintsFromSetCreateAccount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'authorizeAccount',
            'installAction',
            'callToAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property createAccount can\'t be set as the property %s is already set. Only one property must be set among these properties: createAccount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set createAccount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AppLinkInfo $createAccount
     * @return \StructType\AppLinkResult
     */
    public function setCreateAccount(\StructType\AppLinkInfo $createAccount = null)
    {
        // validation for constraint: choice(authorizeAccount, createAccount, installAction, callToAction)
        if ('' !== ($createAccountChoiceErrorMessage = self::validateCreateAccountForChoiceConstraintsFromSetCreateAccount($createAccount))) {
            throw new \InvalidArgumentException($createAccountChoiceErrorMessage, __LINE__);
        }
        if (is_null($createAccount) || (is_array($createAccount) && empty($createAccount))) {
            unset($this->createAccount);
        } else {
            $this->createAccount = $createAccount;
        }
        return $this;
    }
    /**
     * Get installAction value
     * @return \StructType\CallToActionInfo|null
     */
    public function getInstallAction()
    {
        return isset($this->installAction) ? $this->installAction : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInstallAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstallAction method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInstallActionForChoiceConstraintsFromSetInstallAction($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'authorizeAccount',
            'createAccount',
            'callToAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property installAction can\'t be set as the property %s is already set. Only one property must be set among these properties: installAction, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set installAction value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CallToActionInfo $installAction
     * @return \StructType\AppLinkResult
     */
    public function setInstallAction(\StructType\CallToActionInfo $installAction = null)
    {
        // validation for constraint: choice(authorizeAccount, createAccount, installAction, callToAction)
        if ('' !== ($installActionChoiceErrorMessage = self::validateInstallActionForChoiceConstraintsFromSetInstallAction($installAction))) {
            throw new \InvalidArgumentException($installActionChoiceErrorMessage, __LINE__);
        }
        if (is_null($installAction) || (is_array($installAction) && empty($installAction))) {
            unset($this->installAction);
        } else {
            $this->installAction = $installAction;
        }
        return $this;
    }
}
