<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appLinkInfo StructType
 * @subpackage Structs
 */
class AppLinkInfo extends AbstractStructBase
{
    /**
     * The appUrlStringId
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $appUrlStringId;
    /**
     * The appUrl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $appUrl;
    /**
     * The deviceLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeviceLinkCodeResult
     */
    public $deviceLink;
    /**
     * The failureStringId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failureStringId;
    /**
     * The failureUrl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $failureUrl;
    /**
     * The failureUrlStringId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failureUrlStringId;
    /**
     * Constructor method for appLinkInfo
     * @uses AppLinkInfo::setAppUrlStringId()
     * @uses AppLinkInfo::setAppUrl()
     * @uses AppLinkInfo::setDeviceLink()
     * @uses AppLinkInfo::setFailureStringId()
     * @uses AppLinkInfo::setFailureUrl()
     * @uses AppLinkInfo::setFailureUrlStringId()
     * @param string $appUrlStringId
     * @param string $appUrl
     * @param \StructType\DeviceLinkCodeResult $deviceLink
     * @param string $failureStringId
     * @param string $failureUrl
     * @param string $failureUrlStringId
     */
    public function __construct($appUrlStringId = null, $appUrl = null, \StructType\DeviceLinkCodeResult $deviceLink = null, $failureStringId = null, $failureUrl = null, $failureUrlStringId = null)
    {
        $this
            ->setAppUrlStringId($appUrlStringId)
            ->setAppUrl($appUrl)
            ->setDeviceLink($deviceLink)
            ->setFailureStringId($failureStringId)
            ->setFailureUrl($failureUrl)
            ->setFailureUrlStringId($failureUrlStringId);
    }
    /**
     * Get appUrlStringId value
     * @return string
     */
    public function getAppUrlStringId()
    {
        return $this->appUrlStringId;
    }
    /**
     * Set appUrlStringId value
     * @param string $appUrlStringId
     * @return \StructType\AppLinkInfo
     */
    public function setAppUrlStringId($appUrlStringId = null)
    {
        // validation for constraint: string
        if (!is_null($appUrlStringId) && !is_string($appUrlStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appUrlStringId, true), gettype($appUrlStringId)), __LINE__);
        }
        $this->appUrlStringId = $appUrlStringId;
        return $this;
    }
    /**
     * Get appUrl value
     * @return string|null
     */
    public function getAppUrl()
    {
        return $this->appUrl;
    }
    /**
     * Set appUrl value
     * @param string $appUrl
     * @return \StructType\AppLinkInfo
     */
    public function setAppUrl($appUrl = null)
    {
        // validation for constraint: string
        if (!is_null($appUrl) && !is_string($appUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appUrl, true), gettype($appUrl)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($appUrl) && mb_strlen($appUrl) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($appUrl)), __LINE__);
        }
        $this->appUrl = $appUrl;
        return $this;
    }
    /**
     * Get deviceLink value
     * @return \StructType\DeviceLinkCodeResult|null
     */
    public function getDeviceLink()
    {
        return $this->deviceLink;
    }
    /**
     * Set deviceLink value
     * @param \StructType\DeviceLinkCodeResult $deviceLink
     * @return \StructType\AppLinkInfo
     */
    public function setDeviceLink(\StructType\DeviceLinkCodeResult $deviceLink = null)
    {
        $this->deviceLink = $deviceLink;
        return $this;
    }
    /**
     * Get failureStringId value
     * @return string|null
     */
    public function getFailureStringId()
    {
        return $this->failureStringId;
    }
    /**
     * Set failureStringId value
     * @param string $failureStringId
     * @return \StructType\AppLinkInfo
     */
    public function setFailureStringId($failureStringId = null)
    {
        // validation for constraint: string
        if (!is_null($failureStringId) && !is_string($failureStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureStringId, true), gettype($failureStringId)), __LINE__);
        }
        $this->failureStringId = $failureStringId;
        return $this;
    }
    /**
     * Get failureUrl value
     * @return string|null
     */
    public function getFailureUrl()
    {
        return $this->failureUrl;
    }
    /**
     * Set failureUrl value
     * @param string $failureUrl
     * @return \StructType\AppLinkInfo
     */
    public function setFailureUrl($failureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($failureUrl) && !is_string($failureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureUrl, true), gettype($failureUrl)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($failureUrl) && mb_strlen($failureUrl) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($failureUrl)), __LINE__);
        }
        $this->failureUrl = $failureUrl;
        return $this;
    }
    /**
     * Get failureUrlStringId value
     * @return string|null
     */
    public function getFailureUrlStringId()
    {
        return $this->failureUrlStringId;
    }
    /**
     * Set failureUrlStringId value
     * @param string $failureUrlStringId
     * @return \StructType\AppLinkInfo
     */
    public function setFailureUrlStringId($failureUrlStringId = null)
    {
        // validation for constraint: string
        if (!is_null($failureUrlStringId) && !is_string($failureUrlStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureUrlStringId, true), gettype($failureUrlStringId)), __LINE__);
        }
        $this->failureUrlStringId = $failureUrlStringId;
        return $this;
    }
}
