<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Credentials $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\Credentials $credentials, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\StructType\Context $context, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named search
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Search $parameters
     * @return \StructType\SearchResponse|bool
     */
    public function search(\StructType\Search $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->search($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
