<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reorder ServiceType
 * @subpackage Services
 */
class Reorder extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Credentials $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\Credentials $credentials, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\StructType\Context $context, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named reorderContainer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReorderContainer $parameters
     * @return \StructType\ReorderContainerResponse|bool
     */
    public function reorderContainer(\StructType\ReorderContainer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reorderContainer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReorderContainerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
