<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rename ServiceType
 * @subpackage Services
 */
class Rename extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Credentials $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\Credentials $credentials, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\StructType\Context $context, $nameSpace = 'http://www.sonos.com/Services/1.1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named renameContainer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: credentials, context
     * - SOAPHeaderNamespaces: http://www.sonos.com/Services/1.1, http://www.sonos.com/Services/1.1
     * - SOAPHeaderTypes: \StructType\Credentials, \StructType\Context
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RenameContainer $parameters
     * @return \StructType\RenameContainerResponse|bool
     */
    public function renameContainer(\StructType\RenameContainer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->renameContainer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RenameContainerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
