<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispoServiceLangue StructType
 * @subpackage Structs
 */
class DispoServiceLangue extends AbstractStructBase
{
    /**
     * The EstDisponible
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $EstDisponible;
    /**
     * The DureeAvantFermeture
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DureeAvantFermeture;
    /**
     * The DureeFermeture
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DureeFermeture;
    /**
     * The DureeAvantReouverture
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DureeAvantReouverture;
    /**
     * Constructor method for DispoServiceLangue
     * @uses DispoServiceLangue::setEstDisponible()
     * @uses DispoServiceLangue::setDureeAvantFermeture()
     * @uses DispoServiceLangue::setDureeFermeture()
     * @uses DispoServiceLangue::setDureeAvantReouverture()
     * @param bool $estDisponible
     * @param int $dureeAvantFermeture
     * @param int $dureeFermeture
     * @param int $dureeAvantReouverture
     */
    public function __construct($estDisponible = null, $dureeAvantFermeture = null, $dureeFermeture = null, $dureeAvantReouverture = null)
    {
        $this
            ->setEstDisponible($estDisponible)
            ->setDureeAvantFermeture($dureeAvantFermeture)
            ->setDureeFermeture($dureeFermeture)
            ->setDureeAvantReouverture($dureeAvantReouverture);
    }
    /**
     * Get EstDisponible value
     * @return bool
     */
    public function getEstDisponible()
    {
        return $this->EstDisponible;
    }
    /**
     * Set EstDisponible value
     * @param bool $estDisponible
     * @return \StructType\DispoServiceLangue
     */
    public function setEstDisponible($estDisponible = null)
    {
        // validation for constraint: boolean
        if (!is_null($estDisponible) && !is_bool($estDisponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estDisponible, true), gettype($estDisponible)), __LINE__);
        }
        $this->EstDisponible = $estDisponible;
        return $this;
    }
    /**
     * Get DureeAvantFermeture value
     * @return int
     */
    public function getDureeAvantFermeture()
    {
        return $this->DureeAvantFermeture;
    }
    /**
     * Set DureeAvantFermeture value
     * @param int $dureeAvantFermeture
     * @return \StructType\DispoServiceLangue
     */
    public function setDureeAvantFermeture($dureeAvantFermeture = null)
    {
        // validation for constraint: int
        if (!is_null($dureeAvantFermeture) && !(is_int($dureeAvantFermeture) || ctype_digit($dureeAvantFermeture))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dureeAvantFermeture, true), gettype($dureeAvantFermeture)), __LINE__);
        }
        $this->DureeAvantFermeture = $dureeAvantFermeture;
        return $this;
    }
    /**
     * Get DureeFermeture value
     * @return int
     */
    public function getDureeFermeture()
    {
        return $this->DureeFermeture;
    }
    /**
     * Set DureeFermeture value
     * @param int $dureeFermeture
     * @return \StructType\DispoServiceLangue
     */
    public function setDureeFermeture($dureeFermeture = null)
    {
        // validation for constraint: int
        if (!is_null($dureeFermeture) && !(is_int($dureeFermeture) || ctype_digit($dureeFermeture))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dureeFermeture, true), gettype($dureeFermeture)), __LINE__);
        }
        $this->DureeFermeture = $dureeFermeture;
        return $this;
    }
    /**
     * Get DureeAvantReouverture value
     * @return int
     */
    public function getDureeAvantReouverture()
    {
        return $this->DureeAvantReouverture;
    }
    /**
     * Set DureeAvantReouverture value
     * @param int $dureeAvantReouverture
     * @return \StructType\DispoServiceLangue
     */
    public function setDureeAvantReouverture($dureeAvantReouverture = null)
    {
        // validation for constraint: int
        if (!is_null($dureeAvantReouverture) && !(is_int($dureeAvantReouverture) || ctype_digit($dureeAvantReouverture))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dureeAvantReouverture, true), gettype($dureeAvantReouverture)), __LINE__);
        }
        $this->DureeAvantReouverture = $dureeAvantReouverture;
        return $this;
    }
}
