<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContexteSession StructType
 * Meta information extracted from the WSDL
 * - type: s2:ContexteSession
 * @subpackage Structs
 */
class ContexteSession extends AbstractStructBase
{
    /**
     * The CodeUtilisateur
     * @var string
     */
    public $CodeUtilisateur;
    /**
     * The NoTed
     * @var string
     */
    public $NoTed;
    /**
     * The NoUsager
     * @var string
     */
    public $NoUsager;
    /**
     * The TypeSdu
     * @var string
     */
    public $TypeSdu;
    /**
     * The SeqSdu
     * @var string
     */
    public $SeqSdu;
    /**
     * The CodeService
     * @var string
     */
    public $CodeService;
    /**
     * The NoVersionService
     * @var string
     */
    public $NoVersionService;
    /**
     * The CodeFormulaire
     * @var string
     */
    public $CodeFormulaire;
    /**
     * The IdPartenaire
     * @var string
     */
    public $IdPartenaire;
    /**
     * The IdLogiciel
     * @var string
     */
    public $IdLogiciel;
    /**
     * The NoSerieLogiciel
     * @var string
     */
    public $NoSerieLogiciel;
    /**
     * The ModeSimulation
     * @var string
     */
    public $ModeSimulation;
    /**
     * The NoGropPa
     * @var int
     */
    public $NoGropPa;
    /**
     * Constructor method for ContexteSession
     * @uses ContexteSession::setCodeUtilisateur()
     * @uses ContexteSession::setNoTed()
     * @uses ContexteSession::setNoUsager()
     * @uses ContexteSession::setTypeSdu()
     * @uses ContexteSession::setSeqSdu()
     * @uses ContexteSession::setCodeService()
     * @uses ContexteSession::setNoVersionService()
     * @uses ContexteSession::setCodeFormulaire()
     * @uses ContexteSession::setIdPartenaire()
     * @uses ContexteSession::setIdLogiciel()
     * @uses ContexteSession::setNoSerieLogiciel()
     * @uses ContexteSession::setModeSimulation()
     * @uses ContexteSession::setNoGropPa()
     * @param string $codeUtilisateur
     * @param string $noTed
     * @param string $noUsager
     * @param string $typeSdu
     * @param string $seqSdu
     * @param string $codeService
     * @param string $noVersionService
     * @param string $codeFormulaire
     * @param string $idPartenaire
     * @param string $idLogiciel
     * @param string $noSerieLogiciel
     * @param string $modeSimulation
     * @param int $noGropPa
     */
    public function __construct($codeUtilisateur = null, $noTed = null, $noUsager = null, $typeSdu = null, $seqSdu = null, $codeService = null, $noVersionService = null, $codeFormulaire = null, $idPartenaire = null, $idLogiciel = null, $noSerieLogiciel = null, $modeSimulation = null, $noGropPa = null)
    {
        $this
            ->setCodeUtilisateur($codeUtilisateur)
            ->setNoTed($noTed)
            ->setNoUsager($noUsager)
            ->setTypeSdu($typeSdu)
            ->setSeqSdu($seqSdu)
            ->setCodeService($codeService)
            ->setNoVersionService($noVersionService)
            ->setCodeFormulaire($codeFormulaire)
            ->setIdPartenaire($idPartenaire)
            ->setIdLogiciel($idLogiciel)
            ->setNoSerieLogiciel($noSerieLogiciel)
            ->setModeSimulation($modeSimulation)
            ->setNoGropPa($noGropPa);
    }
    /**
     * Get CodeUtilisateur value
     * @return string|null
     */
    public function getCodeUtilisateur()
    {
        return $this->CodeUtilisateur;
    }
    /**
     * Set CodeUtilisateur value
     * @param string $codeUtilisateur
     * @return \StructType\ContexteSession
     */
    public function setCodeUtilisateur($codeUtilisateur = null)
    {
        // validation for constraint: string
        if (!is_null($codeUtilisateur) && !is_string($codeUtilisateur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeUtilisateur, true), gettype($codeUtilisateur)), __LINE__);
        }
        $this->CodeUtilisateur = $codeUtilisateur;
        return $this;
    }
    /**
     * Get NoTed value
     * @return string|null
     */
    public function getNoTed()
    {
        return $this->NoTed;
    }
    /**
     * Set NoTed value
     * @param string $noTed
     * @return \StructType\ContexteSession
     */
    public function setNoTed($noTed = null)
    {
        // validation for constraint: string
        if (!is_null($noTed) && !is_string($noTed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noTed, true), gettype($noTed)), __LINE__);
        }
        $this->NoTed = $noTed;
        return $this;
    }
    /**
     * Get NoUsager value
     * @return string|null
     */
    public function getNoUsager()
    {
        return $this->NoUsager;
    }
    /**
     * Set NoUsager value
     * @param string $noUsager
     * @return \StructType\ContexteSession
     */
    public function setNoUsager($noUsager = null)
    {
        // validation for constraint: string
        if (!is_null($noUsager) && !is_string($noUsager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noUsager, true), gettype($noUsager)), __LINE__);
        }
        $this->NoUsager = $noUsager;
        return $this;
    }
    /**
     * Get TypeSdu value
     * @return string|null
     */
    public function getTypeSdu()
    {
        return $this->TypeSdu;
    }
    /**
     * Set TypeSdu value
     * @param string $typeSdu
     * @return \StructType\ContexteSession
     */
    public function setTypeSdu($typeSdu = null)
    {
        // validation for constraint: string
        if (!is_null($typeSdu) && !is_string($typeSdu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeSdu, true), gettype($typeSdu)), __LINE__);
        }
        $this->TypeSdu = $typeSdu;
        return $this;
    }
    /**
     * Get SeqSdu value
     * @return string|null
     */
    public function getSeqSdu()
    {
        return $this->SeqSdu;
    }
    /**
     * Set SeqSdu value
     * @param string $seqSdu
     * @return \StructType\ContexteSession
     */
    public function setSeqSdu($seqSdu = null)
    {
        // validation for constraint: string
        if (!is_null($seqSdu) && !is_string($seqSdu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seqSdu, true), gettype($seqSdu)), __LINE__);
        }
        $this->SeqSdu = $seqSdu;
        return $this;
    }
    /**
     * Get CodeService value
     * @return string|null
     */
    public function getCodeService()
    {
        return $this->CodeService;
    }
    /**
     * Set CodeService value
     * @param string $codeService
     * @return \StructType\ContexteSession
     */
    public function setCodeService($codeService = null)
    {
        // validation for constraint: string
        if (!is_null($codeService) && !is_string($codeService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeService, true), gettype($codeService)), __LINE__);
        }
        $this->CodeService = $codeService;
        return $this;
    }
    /**
     * Get NoVersionService value
     * @return string|null
     */
    public function getNoVersionService()
    {
        return $this->NoVersionService;
    }
    /**
     * Set NoVersionService value
     * @param string $noVersionService
     * @return \StructType\ContexteSession
     */
    public function setNoVersionService($noVersionService = null)
    {
        // validation for constraint: string
        if (!is_null($noVersionService) && !is_string($noVersionService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noVersionService, true), gettype($noVersionService)), __LINE__);
        }
        $this->NoVersionService = $noVersionService;
        return $this;
    }
    /**
     * Get CodeFormulaire value
     * @return string|null
     */
    public function getCodeFormulaire()
    {
        return $this->CodeFormulaire;
    }
    /**
     * Set CodeFormulaire value
     * @param string $codeFormulaire
     * @return \StructType\ContexteSession
     */
    public function setCodeFormulaire($codeFormulaire = null)
    {
        // validation for constraint: string
        if (!is_null($codeFormulaire) && !is_string($codeFormulaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeFormulaire, true), gettype($codeFormulaire)), __LINE__);
        }
        $this->CodeFormulaire = $codeFormulaire;
        return $this;
    }
    /**
     * Get IdPartenaire value
     * @return string|null
     */
    public function getIdPartenaire()
    {
        return $this->IdPartenaire;
    }
    /**
     * Set IdPartenaire value
     * @param string $idPartenaire
     * @return \StructType\ContexteSession
     */
    public function setIdPartenaire($idPartenaire = null)
    {
        // validation for constraint: string
        if (!is_null($idPartenaire) && !is_string($idPartenaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idPartenaire, true), gettype($idPartenaire)), __LINE__);
        }
        $this->IdPartenaire = $idPartenaire;
        return $this;
    }
    /**
     * Get IdLogiciel value
     * @return string|null
     */
    public function getIdLogiciel()
    {
        return $this->IdLogiciel;
    }
    /**
     * Set IdLogiciel value
     * @param string $idLogiciel
     * @return \StructType\ContexteSession
     */
    public function setIdLogiciel($idLogiciel = null)
    {
        // validation for constraint: string
        if (!is_null($idLogiciel) && !is_string($idLogiciel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idLogiciel, true), gettype($idLogiciel)), __LINE__);
        }
        $this->IdLogiciel = $idLogiciel;
        return $this;
    }
    /**
     * Get NoSerieLogiciel value
     * @return string|null
     */
    public function getNoSerieLogiciel()
    {
        return $this->NoSerieLogiciel;
    }
    /**
     * Set NoSerieLogiciel value
     * @param string $noSerieLogiciel
     * @return \StructType\ContexteSession
     */
    public function setNoSerieLogiciel($noSerieLogiciel = null)
    {
        // validation for constraint: string
        if (!is_null($noSerieLogiciel) && !is_string($noSerieLogiciel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noSerieLogiciel, true), gettype($noSerieLogiciel)), __LINE__);
        }
        $this->NoSerieLogiciel = $noSerieLogiciel;
        return $this;
    }
    /**
     * Get ModeSimulation value
     * @return string|null
     */
    public function getModeSimulation()
    {
        return $this->ModeSimulation;
    }
    /**
     * Set ModeSimulation value
     * @param string $modeSimulation
     * @return \StructType\ContexteSession
     */
    public function setModeSimulation($modeSimulation = null)
    {
        // validation for constraint: string
        if (!is_null($modeSimulation) && !is_string($modeSimulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeSimulation, true), gettype($modeSimulation)), __LINE__);
        }
        $this->ModeSimulation = $modeSimulation;
        return $this;
    }
    /**
     * Get NoGropPa value
     * @return int|null
     */
    public function getNoGropPa()
    {
        return $this->NoGropPa;
    }
    /**
     * Set NoGropPa value
     * @param int $noGropPa
     * @return \StructType\ContexteSession
     */
    public function setNoGropPa($noGropPa = null)
    {
        // validation for constraint: int
        if (!is_null($noGropPa) && !(is_int($noGropPa) || ctype_digit($noGropPa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noGropPa, true), gettype($noGropPa)), __LINE__);
        }
        $this->NoGropPa = $noGropPa;
        return $this;
    }
}
