<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContexteExecution StructType
 * Meta information extracted from the WSDL
 * - type: s1:ContexteExecution
 * @subpackage Structs
 */
class ContexteExecution extends AbstractStructBase
{
    /**
     * The Logon
     * @var string
     */
    public $Logon;
    /**
     * The MotDePasse
     * @var string
     */
    public $MotDePasse;
    /**
     * Constructor method for ContexteExecution
     * @uses ContexteExecution::setLogon()
     * @uses ContexteExecution::setMotDePasse()
     * @param string $logon
     * @param string $motDePasse
     */
    public function __construct($logon = null, $motDePasse = null)
    {
        $this
            ->setLogon($logon)
            ->setMotDePasse($motDePasse);
    }
    /**
     * Get Logon value
     * @return string|null
     */
    public function getLogon()
    {
        return $this->Logon;
    }
    /**
     * Set Logon value
     * @param string $logon
     * @return \StructType\ContexteExecution
     */
    public function setLogon($logon = null)
    {
        // validation for constraint: string
        if (!is_null($logon) && !is_string($logon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logon, true), gettype($logon)), __LINE__);
        }
        $this->Logon = $logon;
        return $this;
    }
    /**
     * Get MotDePasse value
     * @return string|null
     */
    public function getMotDePasse()
    {
        return $this->MotDePasse;
    }
    /**
     * Set MotDePasse value
     * @param string $motDePasse
     * @return \StructType\ContexteExecution
     */
    public function setMotDePasse($motDePasse = null)
    {
        // validation for constraint: string
        if (!is_null($motDePasse) && !is_string($motDePasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motDePasse, true), gettype($motDePasse)), __LINE__);
        }
        $this->MotDePasse = $motDePasse;
        return $this;
    }
}
