<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obtenir ServiceType
 * @subpackage Services
 */
class Obtenir extends AbstractSoapClientBase
{
    /**
     * Sets the ContexteExecution SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ContexteExecution $contexteExecution
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContexteExecution(\StructType\ContexteExecution $contexteExecution, $nameSpace = 'temporaire', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ContexteExecution', $contexteExecution, $mustUnderstand, $actor);
    }
    /**
     * Sets the ContexteSession SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ContexteSession $contexteSession
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContexteSession(\StructType\ContexteSession $contexteSession, $nameSpace = 'http://www.mrq.gouv.qc.ca/T1A/04111900/Communs', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ContexteSession', $contexteSession, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ObtenirUrlsServices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContexteExecution, ContexteSession
     * - SOAPHeaderNamespaces: temporaire, http://www.mrq.gouv.qc.ca/T1A/04111900/Communs
     * - SOAPHeaderTypes: \StructType\ContexteExecution, \StructType\ContexteSession
     * - SOAPHeaders: required, required
     * - documentation: Retourne les adresses URL des services web passés en paramètres.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtenirUrlsServices $parameters
     * @return \StructType\ObtenirUrlsServicesResponse|bool
     */
    public function ObtenirUrlsServices(\StructType\ObtenirUrlsServices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtenirUrlsServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObtenirUrlsServicesDetail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContexteExecution, ContexteSession
     * - SOAPHeaderNamespaces: temporaire, http://www.mrq.gouv.qc.ca/T1A/04111900/Communs
     * - SOAPHeaderTypes: \StructType\ContexteExecution, \StructType\ContexteSession
     * - SOAPHeaders: required, required
     * - documentation: Retournes les adresses URL détaillées des services web passés en paramètres.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtenirUrlsServicesDetail $parameters
     * @return \StructType\ObtenirUrlsServicesDetailResponse|bool
     */
    public function ObtenirUrlsServicesDetail(\StructType\ObtenirUrlsServicesDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtenirUrlsServicesDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObtenirUrlsServicesDetailResponse|\StructType\ObtenirUrlsServicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
