<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnSmsResult StructType
 * @subpackage Structs
 */
class ReturnSmsResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The WarningMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningMessage;
    /**
     * The NikIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLong
     */
    public $NikIds;
    /**
     * Constructor method for ReturnSmsResult
     * @uses ReturnSmsResult::setStatus()
     * @uses ReturnSmsResult::setId()
     * @uses ReturnSmsResult::setWarningMessage()
     * @uses ReturnSmsResult::setNikIds()
     * @param string $status
     * @param string $id
     * @param string $warningMessage
     * @param \ArrayType\ArrayOfLong $nikIds
     */
    public function __construct($status = null, $id = null, $warningMessage = null, \ArrayType\ArrayOfLong $nikIds = null)
    {
        $this
            ->setStatus($status)
            ->setId($id)
            ->setWarningMessage($warningMessage)
            ->setNikIds($nikIds);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\SmsReturn::valueIsValid()
     * @uses \EnumType\SmsReturn::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ReturnSmsResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SmsReturn::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SmsReturn', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\SmsReturn::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ReturnSmsResult
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get WarningMessage value
     * @return string|null
     */
    public function getWarningMessage()
    {
        return $this->WarningMessage;
    }
    /**
     * Set WarningMessage value
     * @param string $warningMessage
     * @return \StructType\ReturnSmsResult
     */
    public function setWarningMessage($warningMessage = null)
    {
        // validation for constraint: string
        if (!is_null($warningMessage) && !is_string($warningMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningMessage, true), gettype($warningMessage)), __LINE__);
        }
        $this->WarningMessage = $warningMessage;
        return $this;
    }
    /**
     * Get NikIds value
     * @return \ArrayType\ArrayOfLong|null
     */
    public function getNikIds()
    {
        return $this->NikIds;
    }
    /**
     * Set NikIds value
     * @param \ArrayType\ArrayOfLong $nikIds
     * @return \StructType\ReturnSmsResult
     */
    public function setNikIds(\ArrayType\ArrayOfLong $nikIds = null)
    {
        $this->NikIds = $nikIds;
        return $this;
    }
}
