<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSmsModel StructType
 * @subpackage Structs
 */
class GroupSmsModel extends AbstractStructBase
{
    /**
     * The SendOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendOn;
    /**
     * The SendType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendType;
    /**
     * The SenderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderNumber;
    /**
     * The Numbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Numbers;
    /**
     * The YourMessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLong
     */
    public $YourMessageId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for GroupSmsModel
     * @uses GroupSmsModel::setSendOn()
     * @uses GroupSmsModel::setSendType()
     * @uses GroupSmsModel::setSenderNumber()
     * @uses GroupSmsModel::setNumbers()
     * @uses GroupSmsModel::setYourMessageId()
     * @uses GroupSmsModel::setMessage()
     * @param string $sendOn
     * @param string $sendType
     * @param string $senderNumber
     * @param \ArrayType\ArrayOfString $numbers
     * @param \ArrayType\ArrayOfLong $yourMessageId
     * @param string $message
     */
    public function __construct($sendOn = null, $sendType = null, $senderNumber = null, \ArrayType\ArrayOfString $numbers = null, \ArrayType\ArrayOfLong $yourMessageId = null, $message = null)
    {
        $this
            ->setSendOn($sendOn)
            ->setSendType($sendType)
            ->setSenderNumber($senderNumber)
            ->setNumbers($numbers)
            ->setYourMessageId($yourMessageId)
            ->setMessage($message);
    }
    /**
     * Get SendOn value
     * @return string
     */
    public function getSendOn()
    {
        return $this->SendOn;
    }
    /**
     * Set SendOn value
     * @param string $sendOn
     * @return \StructType\GroupSmsModel
     */
    public function setSendOn($sendOn = null)
    {
        // validation for constraint: string
        if (!is_null($sendOn) && !is_string($sendOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendOn, true), gettype($sendOn)), __LINE__);
        }
        $this->SendOn = $sendOn;
        return $this;
    }
    /**
     * Get SendType value
     * @return string
     */
    public function getSendType()
    {
        return $this->SendType;
    }
    /**
     * Set SendType value
     * @uses \EnumType\OperatorSmsSendType::valueIsValid()
     * @uses \EnumType\OperatorSmsSendType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendType
     * @return \StructType\GroupSmsModel
     */
    public function setSendType($sendType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatorSmsSendType::valueIsValid($sendType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OperatorSmsSendType', is_array($sendType) ? implode(', ', $sendType) : var_export($sendType, true), implode(', ', \EnumType\OperatorSmsSendType::getValidValues())), __LINE__);
        }
        $this->SendType = $sendType;
        return $this;
    }
    /**
     * Get SenderNumber value
     * @return string|null
     */
    public function getSenderNumber()
    {
        return $this->SenderNumber;
    }
    /**
     * Set SenderNumber value
     * @param string $senderNumber
     * @return \StructType\GroupSmsModel
     */
    public function setSenderNumber($senderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderNumber) && !is_string($senderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderNumber, true), gettype($senderNumber)), __LINE__);
        }
        $this->SenderNumber = $senderNumber;
        return $this;
    }
    /**
     * Get Numbers value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getNumbers()
    {
        return $this->Numbers;
    }
    /**
     * Set Numbers value
     * @param \ArrayType\ArrayOfString $numbers
     * @return \StructType\GroupSmsModel
     */
    public function setNumbers(\ArrayType\ArrayOfString $numbers = null)
    {
        $this->Numbers = $numbers;
        return $this;
    }
    /**
     * Get YourMessageId value
     * @return \ArrayType\ArrayOfLong|null
     */
    public function getYourMessageId()
    {
        return $this->YourMessageId;
    }
    /**
     * Set YourMessageId value
     * @param \ArrayType\ArrayOfLong $yourMessageId
     * @return \StructType\GroupSmsModel
     */
    public function setYourMessageId(\ArrayType\ArrayOfLong $yourMessageId = null)
    {
        $this->YourMessageId = $yourMessageId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\GroupSmsModel
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
