<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ptp ServiceType
 * @subpackage Services
 */
class Ptp extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PtpSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PtpSms $parameters
     * @return \StructType\PtpSmsResponse|bool
     */
    public function PtpSms(\StructType\PtpSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PtpSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PtpSmsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
