<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Group ServiceType
 * @subpackage Services
 */
class Group extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GroupSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GroupSms $parameters
     * @return \StructType\GroupSmsResponse|bool
     */
    public function GroupSms(\StructType\GroupSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GroupSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GroupSmsWithPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GroupSmsWithPattern $parameters
     * @return \StructType\GroupSmsWithPatternResponse|bool
     */
    public function GroupSmsWithPattern(\StructType\GroupSmsWithPattern $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GroupSmsWithPattern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GroupSmsResponse|\StructType\GroupSmsWithPatternResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
