<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCredit $parameters
     * @return \StructType\GetCreditResponse|bool
     */
    public function GetCredit(\StructType\GetCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiscountCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiscountCredit $parameters
     * @return \StructType\GetDiscountCreditResponse|bool
     */
    public function GetDiscountCredit(\StructType\GetDiscountCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDiscountCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPanelExpireDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPanelExpireDate $parameters
     * @return \StructType\GetPanelExpireDateResponse|bool
     */
    public function GetPanelExpireDate(\StructType\GetPanelExpireDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPanelExpireDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiveSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiveSms $parameters
     * @return \StructType\GetReceiveSmsResponse|bool
     */
    public function GetReceiveSms(\StructType\GetReceiveSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReceiveSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSmsDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSmsDelivery $parameters
     * @return \StructType\GetSmsDeliveryResponse|bool
     */
    public function GetSmsDelivery(\StructType\GetSmsDelivery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSmsDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSmsDeliveryWithClientId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSmsDeliveryWithClientId $parameters
     * @return \StructType\GetSmsDeliveryWithClientIdResponse|bool
     */
    public function GetSmsDeliveryWithClientId(\StructType\GetSmsDeliveryWithClientId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSmsDeliveryWithClientId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServertime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServertime $parameters
     * @return \StructType\GetServertimeResponse|bool
     */
    public function GetServertime(\StructType\GetServertime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServertime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSenderNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSenderNumbers $parameters
     * @return \StructType\GetSenderNumbersResponse|bool
     */
    public function GetSenderNumbers(\StructType\GetSenderNumbers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSenderNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCreditResponse|\StructType\GetDiscountCreditResponse|\StructType\GetPanelExpireDateResponse|\StructType\GetReceiveSmsResponse|\StructType\GetSenderNumbersResponse|\StructType\GetServertimeResponse|\StructType\GetSmsDeliveryResponse|\StructType\GetSmsDeliveryWithClientIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
