<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SmsStatus EnumType
 * @subpackage Enumerations
 */
class SmsStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Constant for value 'DoNotSend'
     * @return string 'DoNotSend'
     */
    const VALUE_DO_NOT_SEND = 'DoNotSend';
    /**
     * Constant for value 'InQueue'
     * @return string 'InQueue'
     */
    const VALUE_IN_QUEUE = 'InQueue';
    /**
     * Constant for value 'Sent'
     * @return string 'Sent'
     */
    const VALUE_SENT = 'Sent';
    /**
     * Constant for value 'InsufficientCredit'
     * @return string 'InsufficientCredit'
     */
    const VALUE_INSUFFICIENT_CREDIT = 'InsufficientCredit';
    /**
     * Constant for value 'Block'
     * @return string 'Block'
     */
    const VALUE_BLOCK = 'Block';
    /**
     * Constant for value 'NotDeliverdSmsAdvertisingBlock'
     * @return string 'NotDeliverdSmsAdvertisingBlock'
     */
    const VALUE_NOT_DELIVERD_SMS_ADVERTISING_BLOCK = 'NotDeliverdSmsAdvertisingBlock';
    /**
     * Constant for value 'NotDeliverdBlackList'
     * @return string 'NotDeliverdBlackList'
     */
    const VALUE_NOT_DELIVERD_BLACK_LIST = 'NotDeliverdBlackList';
    /**
     * Constant for value 'NotDeliverdDelay'
     * @return string 'NotDeliverdDelay'
     */
    const VALUE_NOT_DELIVERD_DELAY = 'NotDeliverdDelay';
    /**
     * Constant for value 'NotDeliverdCanceled'
     * @return string 'NotDeliverdCanceled'
     */
    const VALUE_NOT_DELIVERD_CANCELED = 'NotDeliverdCanceled';
    /**
     * Constant for value 'NotDeliverdNoViber'
     * @return string 'NotDeliverdNoViber'
     */
    const VALUE_NOT_DELIVERD_NO_VIBER = 'NotDeliverdNoViber';
    /**
     * Constant for value 'NotDeliverdFiltering'
     * @return string 'NotDeliverdFiltering'
     */
    const VALUE_NOT_DELIVERD_FILTERING = 'NotDeliverdFiltering';
    /**
     * Constant for value 'WaitingForRecheckInOprator'
     * @return string 'WaitingForRecheckInOprator'
     */
    const VALUE_WAITING_FOR_RECHECK_IN_OPRATOR = 'WaitingForRecheckInOprator';
    /**
     * Constant for value 'OpratorFault'
     * @return string 'OpratorFault'
     */
    const VALUE_OPRATOR_FAULT = 'OpratorFault';
    /**
     * Constant for value 'NotDeliveredBlocked'
     * @return string 'NotDeliveredBlocked'
     */
    const VALUE_NOT_DELIVERED_BLOCKED = 'NotDeliveredBlocked';
    /**
     * Constant for value 'SendedButStatusNotUpdated'
     * @return string 'SendedButStatusNotUpdated'
     */
    const VALUE_SENDED_BUT_STATUS_NOT_UPDATED = 'SendedButStatusNotUpdated';
    /**
     * Constant for value 'NotDeliveredDuplicate'
     * @return string 'NotDeliveredDuplicate'
     */
    const VALUE_NOT_DELIVERED_DUPLICATE = 'NotDeliveredDuplicate';
    /**
     * Constant for value 'NotDeliveredBlockPanel'
     * @return string 'NotDeliveredBlockPanel'
     */
    const VALUE_NOT_DELIVERED_BLOCK_PANEL = 'NotDeliveredBlockPanel';
    /**
     * Constant for value 'NotDeliveredUnknownNumber'
     * @return string 'NotDeliveredUnknownNumber'
     */
    const VALUE_NOT_DELIVERED_UNKNOWN_NUMBER = 'NotDeliveredUnknownNumber';
    /**
     * Constant for value 'WaitingForDeliveryBeforeSend'
     * @return string 'WaitingForDeliveryBeforeSend'
     */
    const VALUE_WAITING_FOR_DELIVERY_BEFORE_SEND = 'WaitingForDeliveryBeforeSend';
    /**
     * Constant for value 'NotDeliveredUnAccessible'
     * @return string 'NotDeliveredUnAccessible'
     */
    const VALUE_NOT_DELIVERED_UN_ACCESSIBLE = 'NotDeliveredUnAccessible';
    /**
     * Constant for value 'NotDeliveredNotAnswered'
     * @return string 'NotDeliveredNotAnswered'
     */
    const VALUE_NOT_DELIVERED_NOT_ANSWERED = 'NotDeliveredNotAnswered';
    /**
     * Constant for value 'NotDeliveredLineIsBusy'
     * @return string 'NotDeliveredLineIsBusy'
     */
    const VALUE_NOT_DELIVERED_LINE_IS_BUSY = 'NotDeliveredLineIsBusy';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_DO_NOT_SEND
     * @uses self::VALUE_IN_QUEUE
     * @uses self::VALUE_SENT
     * @uses self::VALUE_INSUFFICIENT_CREDIT
     * @uses self::VALUE_BLOCK
     * @uses self::VALUE_NOT_DELIVERD_SMS_ADVERTISING_BLOCK
     * @uses self::VALUE_NOT_DELIVERD_BLACK_LIST
     * @uses self::VALUE_NOT_DELIVERD_DELAY
     * @uses self::VALUE_NOT_DELIVERD_CANCELED
     * @uses self::VALUE_NOT_DELIVERD_NO_VIBER
     * @uses self::VALUE_NOT_DELIVERD_FILTERING
     * @uses self::VALUE_WAITING_FOR_RECHECK_IN_OPRATOR
     * @uses self::VALUE_OPRATOR_FAULT
     * @uses self::VALUE_NOT_DELIVERED_BLOCKED
     * @uses self::VALUE_SENDED_BUT_STATUS_NOT_UPDATED
     * @uses self::VALUE_NOT_DELIVERED_DUPLICATE
     * @uses self::VALUE_NOT_DELIVERED_BLOCK_PANEL
     * @uses self::VALUE_NOT_DELIVERED_UNKNOWN_NUMBER
     * @uses self::VALUE_WAITING_FOR_DELIVERY_BEFORE_SEND
     * @uses self::VALUE_NOT_DELIVERED_UN_ACCESSIBLE
     * @uses self::VALUE_NOT_DELIVERED_NOT_ANSWERED
     * @uses self::VALUE_NOT_DELIVERED_LINE_IS_BUSY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_FOUND,
            self::VALUE_DO_NOT_SEND,
            self::VALUE_IN_QUEUE,
            self::VALUE_SENT,
            self::VALUE_INSUFFICIENT_CREDIT,
            self::VALUE_BLOCK,
            self::VALUE_NOT_DELIVERD_SMS_ADVERTISING_BLOCK,
            self::VALUE_NOT_DELIVERD_BLACK_LIST,
            self::VALUE_NOT_DELIVERD_DELAY,
            self::VALUE_NOT_DELIVERD_CANCELED,
            self::VALUE_NOT_DELIVERD_NO_VIBER,
            self::VALUE_NOT_DELIVERD_FILTERING,
            self::VALUE_WAITING_FOR_RECHECK_IN_OPRATOR,
            self::VALUE_OPRATOR_FAULT,
            self::VALUE_NOT_DELIVERED_BLOCKED,
            self::VALUE_SENDED_BUT_STATUS_NOT_UPDATED,
            self::VALUE_NOT_DELIVERED_DUPLICATE,
            self::VALUE_NOT_DELIVERED_BLOCK_PANEL,
            self::VALUE_NOT_DELIVERED_UNKNOWN_NUMBER,
            self::VALUE_WAITING_FOR_DELIVERY_BEFORE_SEND,
            self::VALUE_NOT_DELIVERED_UN_ACCESSIBLE,
            self::VALUE_NOT_DELIVERED_NOT_ANSWERED,
            self::VALUE_NOT_DELIVERED_LINE_IS_BUSY,
        );
    }
}
