<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSmsStatus ArrayType
 * @subpackage Arrays
 */
class ArrayOfSmsStatus extends AbstractStructArrayBase
{
    /**
     * The SmsStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SmsStatus;
    /**
     * Constructor method for ArrayOfSmsStatus
     * @uses ArrayOfSmsStatus::setSmsStatus()
     * @param string[] $smsStatus
     */
    public function __construct(array $smsStatus = array())
    {
        $this
            ->setSmsStatus($smsStatus);
    }
    /**
     * Get SmsStatus value
     * @return string[]|null
     */
    public function getSmsStatus()
    {
        return $this->SmsStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setSmsStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSmsStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSmsStatusForArrayConstraintsFromSetSmsStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSmsStatusSmsStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\SmsStatus::valueIsValid($arrayOfSmsStatusSmsStatusItem)) {
                $invalidValues[] = is_object($arrayOfSmsStatusSmsStatusItem) ? get_class($arrayOfSmsStatusSmsStatusItem) : sprintf('%s(%s)', gettype($arrayOfSmsStatusSmsStatusItem), var_export($arrayOfSmsStatusSmsStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SmsStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\SmsStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SmsStatus value
     * @uses \EnumType\SmsStatus::valueIsValid()
     * @uses \EnumType\SmsStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $smsStatus
     * @return \ArrayType\ArrayOfSmsStatus
     */
    public function setSmsStatus(array $smsStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($smsStatusArrayErrorMessage = self::validateSmsStatusForArrayConstraintsFromSetSmsStatus($smsStatus))) {
            throw new \InvalidArgumentException($smsStatusArrayErrorMessage, __LINE__);
        }
        $this->SmsStatus = $smsStatus;
        return $this;
    }
    /**
     * Add item to SmsStatus value
     * @uses \EnumType\SmsStatus::valueIsValid()
     * @uses \EnumType\SmsStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfSmsStatus
     */
    public function addToSmsStatus($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SmsStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SmsStatus', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SmsStatus::getValidValues())), __LINE__);
        }
        $this->SmsStatus[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\SmsStatus::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfSmsStatus
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SmsStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SmsStatus', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SmsStatus::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SmsStatus
     */
    public function getAttributeName()
    {
        return 'SmsStatus';
    }
}
