<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SmsReturn EnumType
 * @subpackage Enumerations
 */
class SmsReturn extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Successful'
     * @return string 'Successful'
     */
    const VALUE_SUCCESSFUL = 'Successful';
    /**
     * Constant for value 'UnknownError'
     * @return string 'UnknownError'
     */
    const VALUE_UNKNOWN_ERROR = 'UnknownError';
    /**
     * Constant for value 'InsufficientCredit'
     * @return string 'InsufficientCredit'
     */
    const VALUE_INSUFFICIENT_CREDIT = 'InsufficientCredit';
    /**
     * Constant for value 'ForbiddenHours'
     * @return string 'ForbiddenHours'
     */
    const VALUE_FORBIDDEN_HOURS = 'ForbiddenHours';
    /**
     * Constant for value 'Filtered'
     * @return string 'Filtered'
     */
    const VALUE_FILTERED = 'Filtered';
    /**
     * Constant for value 'NoFilters'
     * @return string 'NoFilters'
     */
    const VALUE_NO_FILTERS = 'NoFilters';
    /**
     * Constant for value 'PrivateNumberIsDisable'
     * @return string 'PrivateNumberIsDisable'
     */
    const VALUE_PRIVATE_NUMBER_IS_DISABLE = 'PrivateNumberIsDisable';
    /**
     * Constant for value 'ArgumentIsNullOrIncorrect'
     * @return string 'ArgumentIsNullOrIncorrect'
     */
    const VALUE_ARGUMENT_IS_NULL_OR_INCORRECT = 'ArgumentIsNullOrIncorrect';
    /**
     * Constant for value 'MessageBodyIsNullOrEmpty'
     * @return string 'MessageBodyIsNullOrEmpty'
     */
    const VALUE_MESSAGE_BODY_IS_NULL_OR_EMPTY = 'MessageBodyIsNullOrEmpty';
    /**
     * Constant for value 'PrivateNumberIsIncorrect'
     * @return string 'PrivateNumberIsIncorrect'
     */
    const VALUE_PRIVATE_NUMBER_IS_INCORRECT = 'PrivateNumberIsIncorrect';
    /**
     * Constant for value 'ReceptionNumberIsIncorrect'
     * @return string 'ReceptionNumberIsIncorrect'
     */
    const VALUE_RECEPTION_NUMBER_IS_INCORRECT = 'ReceptionNumberIsIncorrect';
    /**
     * Constant for value 'SentTypeIsIncorrect'
     * @return string 'SentTypeIsIncorrect'
     */
    const VALUE_SENT_TYPE_IS_INCORRECT = 'SentTypeIsIncorrect';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'PanelIsBlocked'
     * @return string 'PanelIsBlocked'
     */
    const VALUE_PANEL_IS_BLOCKED = 'PanelIsBlocked';
    /**
     * Constant for value 'SiteUpdating'
     * @return string 'SiteUpdating'
     */
    const VALUE_SITE_UPDATING = 'SiteUpdating';
    /**
     * Constant for value 'AudioMessageNotAllowed'
     * @return string 'AudioMessageNotAllowed'
     */
    const VALUE_AUDIO_MESSAGE_NOT_ALLOWED = 'AudioMessageNotAllowed';
    /**
     * Constant for value 'AudioMessageFileSizeNotAllowed'
     * @return string 'AudioMessageFileSizeNotAllowed'
     */
    const VALUE_AUDIO_MESSAGE_FILE_SIZE_NOT_ALLOWED = 'AudioMessageFileSizeNotAllowed';
    /**
     * Constant for value 'PanelExpired'
     * @return string 'PanelExpired'
     */
    const VALUE_PANEL_EXPIRED = 'PanelExpired';
    /**
     * Constant for value 'InvalidUserNameOrPass'
     * @return string 'InvalidUserNameOrPass'
     */
    const VALUE_INVALID_USER_NAME_OR_PASS = 'InvalidUserNameOrPass';
    /**
     * Constant for value 'UserIsWaitForApprove'
     * @return string 'UserIsWaitForApprove'
     */
    const VALUE_USER_IS_WAIT_FOR_APPROVE = 'UserIsWaitForApprove';
    /**
     * Constant for value 'UserApiBlocked'
     * @return string 'UserApiBlocked'
     */
    const VALUE_USER_API_BLOCKED = 'UserApiBlocked';
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESSFUL
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_INSUFFICIENT_CREDIT
     * @uses self::VALUE_FORBIDDEN_HOURS
     * @uses self::VALUE_FILTERED
     * @uses self::VALUE_NO_FILTERS
     * @uses self::VALUE_PRIVATE_NUMBER_IS_DISABLE
     * @uses self::VALUE_ARGUMENT_IS_NULL_OR_INCORRECT
     * @uses self::VALUE_MESSAGE_BODY_IS_NULL_OR_EMPTY
     * @uses self::VALUE_PRIVATE_NUMBER_IS_INCORRECT
     * @uses self::VALUE_RECEPTION_NUMBER_IS_INCORRECT
     * @uses self::VALUE_SENT_TYPE_IS_INCORRECT
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_PANEL_IS_BLOCKED
     * @uses self::VALUE_SITE_UPDATING
     * @uses self::VALUE_AUDIO_MESSAGE_NOT_ALLOWED
     * @uses self::VALUE_AUDIO_MESSAGE_FILE_SIZE_NOT_ALLOWED
     * @uses self::VALUE_PANEL_EXPIRED
     * @uses self::VALUE_INVALID_USER_NAME_OR_PASS
     * @uses self::VALUE_USER_IS_WAIT_FOR_APPROVE
     * @uses self::VALUE_USER_API_BLOCKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESSFUL,
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_INSUFFICIENT_CREDIT,
            self::VALUE_FORBIDDEN_HOURS,
            self::VALUE_FILTERED,
            self::VALUE_NO_FILTERS,
            self::VALUE_PRIVATE_NUMBER_IS_DISABLE,
            self::VALUE_ARGUMENT_IS_NULL_OR_INCORRECT,
            self::VALUE_MESSAGE_BODY_IS_NULL_OR_EMPTY,
            self::VALUE_PRIVATE_NUMBER_IS_INCORRECT,
            self::VALUE_RECEPTION_NUMBER_IS_INCORRECT,
            self::VALUE_SENT_TYPE_IS_INCORRECT,
            self::VALUE_WARNING,
            self::VALUE_PANEL_IS_BLOCKED,
            self::VALUE_SITE_UPDATING,
            self::VALUE_AUDIO_MESSAGE_NOT_ALLOWED,
            self::VALUE_AUDIO_MESSAGE_FILE_SIZE_NOT_ALLOWED,
            self::VALUE_PANEL_EXPIRED,
            self::VALUE_INVALID_USER_NAME_OR_PASS,
            self::VALUE_USER_IS_WAIT_FOR_APPROVE,
            self::VALUE_USER_API_BLOCKED,
        );
    }
}
