<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://niksms.com:1370/NiksmsWebservice.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://niksms.com:1370/NiksmsWebservice.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Group ServiceType
 */
$group = new \ServiceType\Group($options);
/**
 * Sample call for GroupSms operation/method
 */
if ($group->GroupSms(new \StructType\GroupSms()) !== false) {
    print_r($group->getResult());
} else {
    print_r($group->getLastError());
}
/**
 * Sample call for GroupSmsWithPattern operation/method
 */
if ($group->GroupSmsWithPattern(new \StructType\GroupSmsWithPattern()) !== false) {
    print_r($group->getResult());
} else {
    print_r($group->getLastError());
}
/**
 * Samples for Async ServiceType
 */
$async = new \ServiceType\Async($options);
/**
 * Sample call for AsyncGroupSms operation/method
 */
if ($async->AsyncGroupSms(new \StructType\AsyncGroupSms()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for AsyncGroupSmsWithPattern operation/method
 */
if ($async->AsyncGroupSmsWithPattern(new \StructType\AsyncGroupSmsWithPattern()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for AsyncPtpSms operation/method
 */
if ($async->AsyncPtpSms(new \StructType\AsyncPtpSms()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Samples for Ptp ServiceType
 */
$ptp = new \ServiceType\Ptp($options);
/**
 * Sample call for PtpSms operation/method
 */
if ($ptp->PtpSms(new \StructType\PtpSms()) !== false) {
    print_r($ptp->getResult());
} else {
    print_r($ptp->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCredit operation/method
 */
if ($get->GetCredit(new \StructType\GetCredit()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDiscountCredit operation/method
 */
if ($get->GetDiscountCredit(new \StructType\GetDiscountCredit()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPanelExpireDate operation/method
 */
if ($get->GetPanelExpireDate(new \StructType\GetPanelExpireDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiveSms operation/method
 */
if ($get->GetReceiveSms(new \StructType\GetReceiveSms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSmsDelivery operation/method
 */
if ($get->GetSmsDelivery(new \StructType\GetSmsDelivery()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSmsDeliveryWithClientId operation/method
 */
if ($get->GetSmsDeliveryWithClientId(new \StructType\GetSmsDeliveryWithClientId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServertime operation/method
 */
if ($get->GetServertime(new \StructType\GetServertime()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSenderNumbers operation/method
 */
if ($get->GetSenderNumbers(new \StructType\GetSenderNumbers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
/**
 * Sample call for ResetReceiveSmsVisitedStatus operation/method
 */
if ($reset->ResetReceiveSmsVisitedStatus(new \StructType\ResetReceiveSmsVisitedStatus()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
