<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSmsWithPatternModel StructType
 * @subpackage Structs
 */
class GroupSmsWithPatternModel extends AbstractStructBase
{
    /**
     * The SendOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendOn;
    /**
     * The SendType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendType;
    /**
     * The MessagePatternId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MessagePatternId;
    /**
     * The SenderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderNumber;
    /**
     * The Numbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Numbers;
    /**
     * The YourMessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLong
     */
    public $YourMessageId;
    /**
     * Constructor method for GroupSmsWithPatternModel
     * @uses GroupSmsWithPatternModel::setSendOn()
     * @uses GroupSmsWithPatternModel::setSendType()
     * @uses GroupSmsWithPatternModel::setMessagePatternId()
     * @uses GroupSmsWithPatternModel::setSenderNumber()
     * @uses GroupSmsWithPatternModel::setNumbers()
     * @uses GroupSmsWithPatternModel::setYourMessageId()
     * @param string $sendOn
     * @param string $sendType
     * @param int $messagePatternId
     * @param string $senderNumber
     * @param \ArrayType\ArrayOfString $numbers
     * @param \ArrayType\ArrayOfLong $yourMessageId
     */
    public function __construct($sendOn = null, $sendType = null, $messagePatternId = null, $senderNumber = null, \ArrayType\ArrayOfString $numbers = null, \ArrayType\ArrayOfLong $yourMessageId = null)
    {
        $this
            ->setSendOn($sendOn)
            ->setSendType($sendType)
            ->setMessagePatternId($messagePatternId)
            ->setSenderNumber($senderNumber)
            ->setNumbers($numbers)
            ->setYourMessageId($yourMessageId);
    }
    /**
     * Get SendOn value
     * @return string
     */
    public function getSendOn()
    {
        return $this->SendOn;
    }
    /**
     * Set SendOn value
     * @param string $sendOn
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setSendOn($sendOn = null)
    {
        // validation for constraint: string
        if (!is_null($sendOn) && !is_string($sendOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendOn, true), gettype($sendOn)), __LINE__);
        }
        $this->SendOn = $sendOn;
        return $this;
    }
    /**
     * Get SendType value
     * @return string
     */
    public function getSendType()
    {
        return $this->SendType;
    }
    /**
     * Set SendType value
     * @uses \EnumType\OperatorSmsSendType::valueIsValid()
     * @uses \EnumType\OperatorSmsSendType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendType
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setSendType($sendType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatorSmsSendType::valueIsValid($sendType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OperatorSmsSendType', is_array($sendType) ? implode(', ', $sendType) : var_export($sendType, true), implode(', ', \EnumType\OperatorSmsSendType::getValidValues())), __LINE__);
        }
        $this->SendType = $sendType;
        return $this;
    }
    /**
     * Get MessagePatternId value
     * @return int
     */
    public function getMessagePatternId()
    {
        return $this->MessagePatternId;
    }
    /**
     * Set MessagePatternId value
     * @param int $messagePatternId
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setMessagePatternId($messagePatternId = null)
    {
        // validation for constraint: int
        if (!is_null($messagePatternId) && !(is_int($messagePatternId) || ctype_digit($messagePatternId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messagePatternId, true), gettype($messagePatternId)), __LINE__);
        }
        $this->MessagePatternId = $messagePatternId;
        return $this;
    }
    /**
     * Get SenderNumber value
     * @return string|null
     */
    public function getSenderNumber()
    {
        return $this->SenderNumber;
    }
    /**
     * Set SenderNumber value
     * @param string $senderNumber
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setSenderNumber($senderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderNumber) && !is_string($senderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderNumber, true), gettype($senderNumber)), __LINE__);
        }
        $this->SenderNumber = $senderNumber;
        return $this;
    }
    /**
     * Get Numbers value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getNumbers()
    {
        return $this->Numbers;
    }
    /**
     * Set Numbers value
     * @param \ArrayType\ArrayOfString $numbers
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setNumbers(\ArrayType\ArrayOfString $numbers = null)
    {
        $this->Numbers = $numbers;
        return $this;
    }
    /**
     * Get YourMessageId value
     * @return \ArrayType\ArrayOfLong|null
     */
    public function getYourMessageId()
    {
        return $this->YourMessageId;
    }
    /**
     * Set YourMessageId value
     * @param \ArrayType\ArrayOfLong $yourMessageId
     * @return \StructType\GroupSmsWithPatternModel
     */
    public function setYourMessageId(\ArrayType\ArrayOfLong $yourMessageId = null)
    {
        $this->YourMessageId = $yourMessageId;
        return $this;
    }
}
