<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSmsDeliveryWithClientIdModel StructType
 * @subpackage Structs
 */
class GetSmsDeliveryWithClientIdModel extends AbstractStructBase
{
    /**
     * The SmsStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SmsStatus;
    /**
     * The NiksmsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NiksmsId;
    /**
     * Constructor method for GetSmsDeliveryWithClientIdModel
     * @uses GetSmsDeliveryWithClientIdModel::setSmsStatus()
     * @uses GetSmsDeliveryWithClientIdModel::setNiksmsId()
     * @param string $smsStatus
     * @param int $niksmsId
     */
    public function __construct($smsStatus = null, $niksmsId = null)
    {
        $this
            ->setSmsStatus($smsStatus)
            ->setNiksmsId($niksmsId);
    }
    /**
     * Get SmsStatus value
     * @return string
     */
    public function getSmsStatus()
    {
        return $this->SmsStatus;
    }
    /**
     * Set SmsStatus value
     * @uses \EnumType\SmsStatus::valueIsValid()
     * @uses \EnumType\SmsStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smsStatus
     * @return \StructType\GetSmsDeliveryWithClientIdModel
     */
    public function setSmsStatus($smsStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SmsStatus::valueIsValid($smsStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SmsStatus', is_array($smsStatus) ? implode(', ', $smsStatus) : var_export($smsStatus, true), implode(', ', \EnumType\SmsStatus::getValidValues())), __LINE__);
        }
        $this->SmsStatus = $smsStatus;
        return $this;
    }
    /**
     * Get NiksmsId value
     * @return int
     */
    public function getNiksmsId()
    {
        return $this->NiksmsId;
    }
    /**
     * Set NiksmsId value
     * @param int $niksmsId
     * @return \StructType\GetSmsDeliveryWithClientIdModel
     */
    public function setNiksmsId($niksmsId = null)
    {
        // validation for constraint: int
        if (!is_null($niksmsId) && !(is_int($niksmsId) || ctype_digit($niksmsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($niksmsId, true), gettype($niksmsId)), __LINE__);
        }
        $this->NiksmsId = $niksmsId;
        return $this;
    }
}
