<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReceiveSmsModel StructType
 * @subpackage Structs
 */
class GetReceiveSmsModel extends AbstractStructBase
{
    /**
     * The SenderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SenderNumber;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ReceiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReceiveDate;
    /**
     * The IsRelayed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRelayed;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The ReceiveNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiveNumber;
    /**
     * Constructor method for GetReceiveSmsModel
     * @uses GetReceiveSmsModel::setSenderNumber()
     * @uses GetReceiveSmsModel::setId()
     * @uses GetReceiveSmsModel::setReceiveDate()
     * @uses GetReceiveSmsModel::setIsRelayed()
     * @uses GetReceiveSmsModel::setMessage()
     * @uses GetReceiveSmsModel::setReceiveNumber()
     * @param int $senderNumber
     * @param int $id
     * @param string $receiveDate
     * @param bool $isRelayed
     * @param string $message
     * @param string $receiveNumber
     */
    public function __construct($senderNumber = null, $id = null, $receiveDate = null, $isRelayed = null, $message = null, $receiveNumber = null)
    {
        $this
            ->setSenderNumber($senderNumber)
            ->setId($id)
            ->setReceiveDate($receiveDate)
            ->setIsRelayed($isRelayed)
            ->setMessage($message)
            ->setReceiveNumber($receiveNumber);
    }
    /**
     * Get SenderNumber value
     * @return int
     */
    public function getSenderNumber()
    {
        return $this->SenderNumber;
    }
    /**
     * Set SenderNumber value
     * @param int $senderNumber
     * @return \StructType\GetReceiveSmsModel
     */
    public function setSenderNumber($senderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($senderNumber) && !(is_int($senderNumber) || ctype_digit($senderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderNumber, true), gettype($senderNumber)), __LINE__);
        }
        $this->SenderNumber = $senderNumber;
        return $this;
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\GetReceiveSmsModel
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ReceiveDate value
     * @return string
     */
    public function getReceiveDate()
    {
        return $this->ReceiveDate;
    }
    /**
     * Set ReceiveDate value
     * @param string $receiveDate
     * @return \StructType\GetReceiveSmsModel
     */
    public function setReceiveDate($receiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiveDate) && !is_string($receiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveDate, true), gettype($receiveDate)), __LINE__);
        }
        $this->ReceiveDate = $receiveDate;
        return $this;
    }
    /**
     * Get IsRelayed value
     * @return bool
     */
    public function getIsRelayed()
    {
        return $this->IsRelayed;
    }
    /**
     * Set IsRelayed value
     * @param bool $isRelayed
     * @return \StructType\GetReceiveSmsModel
     */
    public function setIsRelayed($isRelayed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelayed) && !is_bool($isRelayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelayed, true), gettype($isRelayed)), __LINE__);
        }
        $this->IsRelayed = $isRelayed;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\GetReceiveSmsModel
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get ReceiveNumber value
     * @return string|null
     */
    public function getReceiveNumber()
    {
        return $this->ReceiveNumber;
    }
    /**
     * Set ReceiveNumber value
     * @param string $receiveNumber
     * @return \StructType\GetReceiveSmsModel
     */
    public function setReceiveNumber($receiveNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiveNumber) && !is_string($receiveNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveNumber, true), gettype($receiveNumber)), __LINE__);
        }
        $this->ReceiveNumber = $receiveNumber;
        return $this;
    }
}
