<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncPtpSms StructType
 * @subpackage Structs
 */
class AsyncPtpSms extends AbstractStructBase
{
    /**
     * The callBackId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $callBackId;
    /**
     * The security
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuthenticationModel
     */
    public $security;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PtpSmsModel
     */
    public $model;
    /**
     * The callBackUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callBackUrl;
    /**
     * Constructor method for AsyncPtpSms
     * @uses AsyncPtpSms::setCallBackId()
     * @uses AsyncPtpSms::setSecurity()
     * @uses AsyncPtpSms::setModel()
     * @uses AsyncPtpSms::setCallBackUrl()
     * @param int $callBackId
     * @param \StructType\AuthenticationModel $security
     * @param \StructType\PtpSmsModel $model
     * @param string $callBackUrl
     */
    public function __construct($callBackId = null, \StructType\AuthenticationModel $security = null, \StructType\PtpSmsModel $model = null, $callBackUrl = null)
    {
        $this
            ->setCallBackId($callBackId)
            ->setSecurity($security)
            ->setModel($model)
            ->setCallBackUrl($callBackUrl);
    }
    /**
     * Get callBackId value
     * @return int
     */
    public function getCallBackId()
    {
        return $this->callBackId;
    }
    /**
     * Set callBackId value
     * @param int $callBackId
     * @return \StructType\AsyncPtpSms
     */
    public function setCallBackId($callBackId = null)
    {
        // validation for constraint: int
        if (!is_null($callBackId) && !(is_int($callBackId) || ctype_digit($callBackId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callBackId, true), gettype($callBackId)), __LINE__);
        }
        $this->callBackId = $callBackId;
        return $this;
    }
    /**
     * Get security value
     * @return \StructType\AuthenticationModel|null
     */
    public function getSecurity()
    {
        return $this->security;
    }
    /**
     * Set security value
     * @param \StructType\AuthenticationModel $security
     * @return \StructType\AsyncPtpSms
     */
    public function setSecurity(\StructType\AuthenticationModel $security = null)
    {
        $this->security = $security;
        return $this;
    }
    /**
     * Get model value
     * @return \StructType\PtpSmsModel|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param \StructType\PtpSmsModel $model
     * @return \StructType\AsyncPtpSms
     */
    public function setModel(\StructType\PtpSmsModel $model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get callBackUrl value
     * @return string|null
     */
    public function getCallBackUrl()
    {
        return $this->callBackUrl;
    }
    /**
     * Set callBackUrl value
     * @param string $callBackUrl
     * @return \StructType\AsyncPtpSms
     */
    public function setCallBackUrl($callBackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($callBackUrl) && !is_string($callBackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callBackUrl, true), gettype($callBackUrl)), __LINE__);
        }
        $this->callBackUrl = $callBackUrl;
        return $this;
    }
}
