<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Async ServiceType
 * @subpackage Services
 */
class Async extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AsyncGroupSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncGroupSms $parameters
     * @return \StructType\AsyncGroupSmsResponse|bool
     */
    public function AsyncGroupSms(\StructType\AsyncGroupSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AsyncGroupSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AsyncGroupSmsWithPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncGroupSmsWithPattern $parameters
     * @return \StructType\AsyncGroupSmsWithPatternResponse|bool
     */
    public function AsyncGroupSmsWithPattern(\StructType\AsyncGroupSmsWithPattern $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AsyncGroupSmsWithPattern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AsyncPtpSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncPtpSms $parameters
     * @return \StructType\AsyncPtpSmsResponse|bool
     */
    public function AsyncPtpSms(\StructType\AsyncPtpSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AsyncPtpSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AsyncGroupSmsResponse|\StructType\AsyncGroupSmsWithPatternResponse|\StructType\AsyncPtpSmsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
