<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.mclowd.com/platform/wsdl/SDS.Interface.SCI.Repository.CLS.xml',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.mclowd.com/platform/wsdl/SDS.Interface.SCI.Repository.CLS.xml',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Client ServiceType
 */
$client = new \ServiceType\Client($options);
/**
 * Sample call for ClientDataFeedSetup operation/method
 */
if ($client->ClientDataFeedSetup(new \StructType\ClientDataFeedSetup()) !== false) {
    print_r($client->getResult());
} else {
    print_r($client->getLastError());
}
/**
 * Samples for Entity ServiceType
 */
$entity = new \ServiceType\Entity($options);
/**
 * Sample call for EntityClientDataFeedList operation/method
 */
if ($entity->EntityClientDataFeedList(new \StructType\EntityClientDataFeedList()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Sample call for EntityClientList operation/method
 */
if ($entity->EntityClientList(new \StructType\EntityClientList()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Sample call for EntityClientSetup operation/method
 */
if ($entity->EntityClientSetup(new \StructType\EntityClientSetup()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Samples for Institution ServiceType
 */
$institution = new \ServiceType\Institution($options);
/**
 * Sample call for InstitutionList operation/method
 */
if ($institution->InstitutionList(new \StructType\InstitutionList()) !== false) {
    print_r($institution->getResult());
} else {
    print_r($institution->getLastError());
}
/**
 * Samples for Request ServiceType
 */
$request = new \ServiceType\Request($options);
/**
 * Sample call for RequestAuthority operation/method
 */
if ($request->RequestAuthority(new \StructType\RequestAuthority()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test(new \StructType\Test()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
