<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityClient StructType
 * @subpackage Structs
 */
class EntityClient extends AbstractStructBase
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The SoftwareID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The CreationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationTime;
    /**
     * The UpdateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateDate;
    /**
     * The UpdateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTime;
    /**
     * The GAFReceived
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GAFReceived;
    /**
     * Constructor method for EntityClient
     * @uses EntityClient::setEntityID()
     * @uses EntityClient::setSoftwareID()
     * @uses EntityClient::setClientID()
     * @uses EntityClient::setName()
     * @uses EntityClient::setActive()
     * @uses EntityClient::setCreationDate()
     * @uses EntityClient::setCreationTime()
     * @uses EntityClient::setUpdateDate()
     * @uses EntityClient::setUpdateTime()
     * @uses EntityClient::setGAFReceived()
     * @param string $entityID
     * @param string $softwareID
     * @param string $clientID
     * @param string $name
     * @param bool $active
     * @param string $creationDate
     * @param string $creationTime
     * @param string $updateDate
     * @param string $updateTime
     * @param bool $gAFReceived
     */
    public function __construct($entityID = null, $softwareID = null, $clientID = null, $name = null, $active = null, $creationDate = null, $creationTime = null, $updateDate = null, $updateTime = null, $gAFReceived = null)
    {
        $this
            ->setEntityID($entityID)
            ->setSoftwareID($softwareID)
            ->setClientID($clientID)
            ->setName($name)
            ->setActive($active)
            ->setCreationDate($creationDate)
            ->setCreationTime($creationTime)
            ->setUpdateDate($updateDate)
            ->setUpdateTime($updateTime)
            ->setGAFReceived($gAFReceived);
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\EntityClient
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get SoftwareID value
     * @return string|null
     */
    public function getSoftwareID()
    {
        return $this->SoftwareID;
    }
    /**
     * Set SoftwareID value
     * @param string $softwareID
     * @return \StructType\EntityClient
     */
    public function setSoftwareID($softwareID = null)
    {
        // validation for constraint: string
        if (!is_null($softwareID) && !is_string($softwareID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softwareID)), __LINE__);
        }
        $this->SoftwareID = $softwareID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\EntityClient
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EntityClient
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\EntityClient
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\EntityClient
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get CreationTime value
     * @return string|null
     */
    public function getCreationTime()
    {
        return $this->CreationTime;
    }
    /**
     * Set CreationTime value
     * @param string $creationTime
     * @return \StructType\EntityClient
     */
    public function setCreationTime($creationTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationTime) && !is_string($creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationTime)), __LINE__);
        }
        $this->CreationTime = $creationTime;
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\EntityClient
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Get UpdateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->UpdateTime;
    }
    /**
     * Set UpdateTime value
     * @param string $updateTime
     * @return \StructType\EntityClient
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->UpdateTime = $updateTime;
        return $this;
    }
    /**
     * Get GAFReceived value
     * @return bool|null
     */
    public function getGAFReceived()
    {
        return $this->GAFReceived;
    }
    /**
     * Set GAFReceived value
     * @param bool $gAFReceived
     * @return \StructType\EntityClient
     */
    public function setGAFReceived($gAFReceived = null)
    {
        // validation for constraint: boolean
        if (!is_null($gAFReceived) && !is_bool($gAFReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gAFReceived)), __LINE__);
        }
        $this->GAFReceived = $gAFReceived;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
