<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Entity ServiceType
 * @subpackage Services
 */
class Entity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EntityClientDataFeedList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityClientDataFeedList $parameters
     * @return \StructType\EntityClientDataFeedListResponse|bool
     */
    public function EntityClientDataFeedList(\StructType\EntityClientDataFeedList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EntityClientDataFeedList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntityClientList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityClientList $parameters
     * @return \StructType\EntityClientListResponse|bool
     */
    public function EntityClientList(\StructType\EntityClientList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EntityClientList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntityClientSetup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityClientSetup $parameters
     * @return \StructType\EntityClientSetupResponse|bool
     */
    public function EntityClientSetup(\StructType\EntityClientSetup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EntityClientSetup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EntityClientDataFeedListResponse|\StructType\EntityClientListResponse|\StructType\EntityClientSetupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
